/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.logging.Logger;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.services.logging.LoggingService;
import org.apache.turbine.services.logging.ServletLogger;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class TurbineLoggingService
extends TurbineBaseService
implements LoggingService {
    protected Hashtable loggersTable = new Hashtable();
    protected Logger defaultLogger = null;
    protected Logger simpleLogger;
    protected ServletContext context = null;
    private ResourceService resources = null;
    private String loggingConfigClassName = null;

    public void init(ServletConfig config) throws InitializationException {
        this.context = config.getServletContext();
        this.defaultLogger = new ServletLogger();
        LoggingConfig lc = this.getLoggingConfig();
        lc.setName("default");
        lc.setInitResource(null);
        lc.setServletContext(this.context);
        lc.init();
        this.defaultLogger.init(lc);
        this.simpleLogger = this.defaultLogger;
        this.internalInit();
        this.setInit(true);
    }

    public LoggingConfig getLoggingConfig() throws InitializationException {
        if (this.loggingConfigClassName == null) {
            ResourceService props = this.getResources();
            this.loggingConfigClassName = props.getString("loggingConfig", "org.apache.turbine.services.logging.PropertiesLoggingConfig");
        }
        try {
            return (LoggingConfig)Class.forName(this.loggingConfigClassName).newInstance();
        }
        catch (InstantiationException ie) {
            throw new InitializationException("LoggingService: Failed to instantiate LoggingConfig: " + this.loggingConfigClassName);
        }
        catch (IllegalAccessException iae) {
            throw new InitializationException("LoggingService: Failed to instantiate LoggingConfig: " + this.loggingConfigClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InitializationException("LoggingService: Failed to instantiate LoggingConfig: " + this.loggingConfigClassName);
        }
    }

    public ResourceService getResources() {
        if (this.resources == null) {
            this.resources = TurbineResources.getResources("services.LoggingService");
        }
        return this.resources;
    }

    private void internalInit() throws InitializationException {
        ResourceService props = this.getResources();
        if (props == null) {
            throw new InitializationException("LoggingService failed to get access to the properties for this service.");
        }
        Vector<LoggingConfig> loggingConfig = new Vector<LoggingConfig>(10);
        String defaultLoggerName = props.getString("default");
        if (defaultLoggerName == null) {
            throw new InitializationException("LoggingService can't find default logger name in the configuration file.");
        }
        Vector facilities = props.getVector("facilities");
        Enumeration f = facilities.elements();
        while (f.hasMoreElements()) {
            String facility = (String)f.nextElement();
            LoggingConfig lc = this.getLoggingConfig();
            lc.setName(facility);
            lc.setInitResource(props);
            lc.setServletContext(this.context);
            lc.init();
            loggingConfig.add(lc);
        }
        Enumeration loggers = loggingConfig.elements();
        while (loggers.hasMoreElements()) {
            LoggingConfig lc = (LoggingConfig)loggers.nextElement();
            this.loadLogger(lc);
        }
        this.defaultLogger = (Logger)this.loggersTable.get(defaultLoggerName);
        if (this.defaultLogger == null) {
            throw new InitializationException("LoggingService can't find default logger in working loggers.");
        }
    }

    protected void loadLogger(LoggingConfig loggingConfig) throws InitializationException {
        String className = loggingConfig.getClassName();
        String loggerName = loggingConfig.getName();
        if (className == null || className.trim().equals("")) {
            throw new InitializationException("LoggingService can't find logger provider class name");
        }
        if (loggerName == null || loggerName.trim().equals("")) {
            throw new InitializationException("LoggingService can't find logger provider name");
        }
        if (this.loggersTable.containsKey(loggerName)) {
            throw new InitializationException("LoggingService has found another logger of the name: " + loggerName);
        }
        Logger logger = null;
        try {
            Class<?> loggerClass = Class.forName(className);
            logger = (Logger)loggerClass.newInstance();
        }
        catch (Exception e) {
            throw new InitializationException("LoggingService can't load logger provider: class doesn't implement Logger interface: " + e.getMessage());
        }
        logger.init(loggingConfig);
        this.loggersTable.put(loggerName, logger);
    }

    public void shutdown() {
        if (!this.getInit()) {
            return;
        }
        Enumeration iter = this.loggersTable.elements();
        while (iter.hasMoreElements()) {
            ((Logger)iter.nextElement()).shutdown();
        }
        this.loggersTable.clear();
        this.defaultLogger = this.simpleLogger;
    }

    public final Logger getLogger() {
        return this.defaultLogger;
    }

    public Logger getLogger(String logName) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger == null) {
            return this.defaultLogger;
        }
        return logger;
    }

    public void setLogLevel(int level) {
        this.defaultLogger.setLogLevel(level);
    }

    public void setLogLevel(String logName, int level) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.setLogLevel(level);
        }
    }

    public void setFormat(String format) {
        this.defaultLogger.setFormat(format);
    }

    public void setFormat(String logName, String format) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.setFormat(format);
        }
    }

    public void debug(String message) {
        this.defaultLogger.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.defaultLogger.debug(message, t);
    }

    public void debug(String logName, String message, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.debug(message, t);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String logName, String message) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.debug(message);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String message, RunData data) {
        this.defaultLogger.debug(message, data);
    }

    public void debug(String message, RunData data, Throwable t) {
        this.defaultLogger.debug(message, data, t);
    }

    public void debug(String logName, String message, RunData data, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.debug(message, data, t);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String logName, String message, RunData data) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.debug(message, data);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String message) {
        this.defaultLogger.info(message);
    }

    public void info(String message, Throwable t) {
        this.defaultLogger.info(message, t);
    }

    public void info(String logName, String message) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.info(message);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String logName, String message, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.info(message, t);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String message, RunData data) {
        this.defaultLogger.info(message, data);
    }

    public void info(String message, RunData data, Throwable t) {
        this.defaultLogger.info(message, data, t);
    }

    public void info(String logName, String message, RunData data) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.info(message, data);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String logName, String message, RunData data, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.info(message, data, t);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String message) {
        this.defaultLogger.warn(message);
    }

    public void warn(String message, Throwable t) {
        this.defaultLogger.warn(message, t);
    }

    public void warn(String logName, String message) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.warn(message);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String logName, String message, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.warn(message, t);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String message, RunData data) {
        this.defaultLogger.warn(message, data);
    }

    public void warn(String message, RunData data, Throwable t) {
        this.defaultLogger.warn(message, data, t);
    }

    public void warn(String logName, String message, RunData data) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.warn(message, data);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String logName, String message, RunData data, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.warn(message, data, t);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String message) {
        this.defaultLogger.error(message);
    }

    public void error(String message, Throwable t) {
        this.defaultLogger.error(message, t);
    }

    public void error(String logName, String message) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.error(message);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String logName, String message, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.error(message, t);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String message, RunData data) {
        this.defaultLogger.error(message, data);
    }

    public void error(String message, RunData data, Throwable t) {
        this.defaultLogger.error(message, data, t);
    }

    public void error(String logName, String message, RunData data) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.error(message, data);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String logName, String message, RunData data, Throwable t) {
        Logger logger = (Logger)this.loggersTable.get(logName);
        if (logger != null) {
            logger.error(message, data, t);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }
}

