/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.util;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.ContentURI;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class UIManager
implements ApplicationTool {
    private static final String SKINS_DIRECTORY = "/ui/skins";
    private static final String IMAGES_DIRECTORY = "/images";
    private static final String SKIN_PROPERTY = "tool.ui.skin";
    private static final String SKIN_PROPERTY_DEFAULT = "default";
    private static final String SKIN_ATTRIBUTE = "org.apache.turbine.services.pull.util.UIManager.skin";
    private static String skinsDirectory;
    private static final String SKIN_PROPS_FILE = "skin.props";
    private static final String SKIN_CSS_FILE = "skin.css";
    private static String resourcesDirectory;
    private static Properties skinProperties;
    private String skinName;

    public void init(Object data) {
        resourcesDirectory = TurbinePull.getResourcesDirectory();
        if (data == null) {
            Log.debug("UI Manager scope is global");
            this.setSkin();
        } else if (data instanceof RunData) {
            Log.debug("UI Manager scope is request");
            this.setSkin((RunData)data);
        } else if (data instanceof User) {
            Log.debug("UI Manager scope is session");
            this.setSkin((User)data);
        }
        skinsDirectory = TurbinePull.getAbsolutePathToResourcesDirectory() + SKINS_DIRECTORY;
        this.loadSkin();
    }

    public void refresh() {
        Log.debug("Refreshing UI manager");
        this.loadSkin();
    }

    public String get(String key) {
        return skinProperties.getProperty(key);
    }

    public String getSkin() {
        return this.skinName;
    }

    public String image(String imageId, RunData data) {
        ContentURI cu = new ContentURI(data);
        StringBuffer sb = new StringBuffer();
        sb.append(resourcesDirectory).append(SKINS_DIRECTORY).append("/").append(this.getSkin()).append(IMAGES_DIRECTORY).append("/").append(imageId);
        return cu.getURI(sb.toString());
    }

    public String image(String imageId) {
        StringBuffer sb = new StringBuffer();
        sb.append(TurbineServlet.getServerScheme()).append("://").append(TurbineServlet.getServerName()).append(":").append(TurbineServlet.getServerPort()).append(TurbineServlet.getContextPath()).append("/").append(resourcesDirectory).append(SKINS_DIRECTORY).append("/").append(this.getSkin()).append(IMAGES_DIRECTORY).append("/").append(imageId);
        return sb.toString();
    }

    public String getStylecss(RunData data) {
        ContentURI cu = new ContentURI(data);
        StringBuffer sb = new StringBuffer();
        sb.append(resourcesDirectory).append(SKINS_DIRECTORY).append("/").append(this.getSkin()).append("/").append(SKIN_CSS_FILE);
        return cu.getURI(sb.toString());
    }

    public String getStylecss() {
        StringBuffer sb = new StringBuffer();
        sb.append(TurbineServlet.getServerScheme()).append("://").append(TurbineServlet.getServerName()).append(":").append(TurbineServlet.getServerPort()).append(TurbineServlet.getContextPath()).append("/").append(resourcesDirectory).append(SKINS_DIRECTORY).append("/").append(this.getSkin()).append("/").append(SKIN_CSS_FILE);
        return sb.toString();
    }

    private void loadSkin() {
        skinProperties = new Properties();
        try {
            FileInputStream is = new FileInputStream(skinsDirectory + "/" + this.getSkin() + "/" + SKIN_PROPS_FILE);
            skinProperties.load(is);
        }
        catch (Exception e) {
            Log.error("Cannot load skin: " + this.skinName);
        }
    }

    public void setSkin() {
        this.skinName = TurbineResources.getString(SKIN_PROPERTY, SKIN_PROPERTY_DEFAULT);
    }

    public void setSkin(String skinName) {
        this.skinName = skinName;
    }

    protected void setSkin(RunData data) {
        this.setSkin();
    }

    protected void setSkin(User user) {
        if (user.getTemp(SKIN_ATTRIBUTE) == null) {
            this.setSkin();
        } else {
            this.setSkin((String)user.getTemp(SKIN_ATTRIBUTE));
        }
    }

    public static void setSkin(User user, String skin) {
        user.setTemp(SKIN_ATTRIBUTE, skin);
    }
}

