/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public abstract class BaseSecurityService
extends TurbineBaseService
implements SecurityService {
    private static Group globalGroup = null;
    private GroupSet allGroups = null;
    private RoleSet allRoles = null;
    private PermissionSet allPermissions = null;
    private int readerCount = 0;
    private UserManager userManager = null;
    private Class userClass = null;
    private static /* synthetic */ Class class$Lorg$apache$turbine$services$security$BaseSecurityService;

    public String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        String secure = this.getProperties().getProperty("secure.passwords", "false").toLowerCase();
        String algorithm = this.getProperties().getProperty("secure.passwords.algorithm", "SHA");
        if (secure.equals("true") || secure.equals("yes")) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] digest = md.digest(password.getBytes("UTF-8"));
                ByteArrayOutputStream bas = new ByteArrayOutputStream(digest.length + digest.length / 3 + 1);
                OutputStream encodedStream = MimeUtility.encode(bas, "base64");
                encodedStream.write(digest);
                return bas.toString();
            }
            catch (Exception e) {
                Log.error("Unable to encrypt password." + e.getMessage());
                Log.error(e);
                return null;
            }
        }
        return password;
    }

    public void init(ServletConfig config) throws InitializationException {
        String userManagerClassName = this.getProperties().getProperty("user.manager", "org.apache.turbine.services.security.DBUserManager");
        String userClassName = this.getProperties().getProperty("user.class", "org.apache.turbine.om.security.TurbineUser");
        try {
            this.userClass = Class.forName(userClassName);
        }
        catch (Exception e) {
            throw new InitializationException("Failed create a Class object for User implementation", e);
        }
        try {
            this.userManager = (UserManager)Class.forName(userManagerClassName).newInstance();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("BaseSecurityService.init: Failed to instantiate UserManager", e);
        }
    }

    public Class getUserClass() throws UnknownEntityException {
        if (this.userClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for User implementation");
        }
        return this.userClass;
    }

    /*
     * WARNING - void declaration
     */
    public User getUserInstance() throws UnknownEntityException {
        void user;
        try {
            User user2 = (User)this.getUserClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", e);
        }
        return user;
    }

    public boolean accountExists(User user) throws DataBackendException {
        return this.userManager.accountExists(user);
    }

    public boolean accountExists(String username) throws DataBackendException {
        return this.userManager.accountExists(username);
    }

    public User getAuthenticatedUser(String username, String password) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return this.userManager.retrieve(username, password);
    }

    public User getUser(String username) throws DataBackendException, UnknownEntityException {
        return this.userManager.retrieve(username);
    }

    public User[] getUsers(Criteria criteria) throws DataBackendException {
        return this.userManager.retrieve(criteria);
    }

    public User getAnonymousUser() throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setUserName("");
        return user;
    }

    public void saveUser(User user) throws UnknownEntityException, DataBackendException {
        this.userManager.store(user);
    }

    public void addUser(User user, String password) throws DataBackendException, EntityExistsException {
        this.userManager.createAccount(user, password);
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        this.revokeAll(user);
        this.userManager.removeAccount(user);
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.userManager.changePassword(user, oldPassword, newPassword);
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        this.userManager.forcePassword(user, password);
    }

    protected synchronized void lockShared() {
        ++this.readerCount;
    }

    protected synchronized void unlockShared() {
        --this.readerCount;
        this.notify();
    }

    protected void lockExclusive() {
        while (this.readerCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void unlockExclusive() {
    }

    public Group getGlobalGroup() {
        if (globalGroup == null) {
            Class clazz = class$Lorg$apache$turbine$services$security$BaseSecurityService != null ? class$Lorg$apache$turbine$services$security$BaseSecurityService : (class$Lorg$apache$turbine$services$security$BaseSecurityService = BaseSecurityService.class$("org.apache.turbine.services.security.BaseSecurityService"));
            synchronized (clazz) {
                if (globalGroup == null) {
                    try {
                        globalGroup = this.getAllGroups().getGroup("global");
                    }
                    catch (DataBackendException e) {
                        Log.error("Failed to retrieve global group object");
                        Log.error(e);
                    }
                }
            }
        }
        return globalGroup;
    }

    public Group getGroup(String name) throws DataBackendException, UnknownEntityException {
        GroupSet groups = this.getAllGroups();
        Group group = groups.getGroup(name);
        if (group != null) {
            return group;
        }
        throw new UnknownEntityException("The specified group does not exist");
    }

    public Role getRole(String name) throws DataBackendException, UnknownEntityException {
        RoleSet roles = this.getAllRoles();
        Role role = roles.getRole(name);
        if (role != null) {
            role.setPermissions(this.getPermissions(role));
            return role;
        }
        throw new UnknownEntityException("The specified role does not exist");
    }

    public Permission getPermission(String name) throws DataBackendException, UnknownEntityException {
        PermissionSet permissions = this.getAllPermissions();
        Permission permission = permissions.getPermission(name);
        if (permission != null) {
            return permission;
        }
        throw new UnknownEntityException("The specified permission does not exist");
    }

    public GroupSet getAllGroups() throws DataBackendException {
        if (this.allGroups == null) {
            BaseSecurityService baseSecurityService = this;
            synchronized (baseSecurityService) {
                if (this.allGroups == null) {
                    this.allGroups = this.getGroups(new Criteria());
                }
            }
        }
        return this.allGroups;
    }

    public RoleSet getAllRoles() throws DataBackendException {
        if (this.allRoles == null) {
            BaseSecurityService baseSecurityService = this;
            synchronized (baseSecurityService) {
                if (this.allRoles == null) {
                    this.allRoles = this.getRoles(new Criteria());
                }
            }
        }
        return this.allRoles;
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        if (this.allPermissions == null) {
            BaseSecurityService baseSecurityService = this;
            synchronized (baseSecurityService) {
                if (this.allPermissions == null) {
                    this.allPermissions = this.getPermissions(new Criteria());
                }
            }
        }
        return this.allPermissions;
    }

    public abstract AccessControlList getACL(User var1) throws DataBackendException, UnknownEntityException;

    public abstract PermissionSet getPermissions(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void grant(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public abstract void revoke(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public abstract void revokeAll(User var1) throws DataBackendException, UnknownEntityException;

    public abstract void grant(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public abstract void revoke(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public abstract void revokeAll(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract Group getNewGroup(String var1);

    public abstract Role getNewRole(String var1);

    public abstract Permission getNewPermission(String var1);

    public abstract GroupSet getGroups(Criteria var1) throws DataBackendException;

    public abstract RoleSet getRoles(Criteria var1) throws DataBackendException;

    public abstract PermissionSet getPermissions(Criteria var1) throws DataBackendException;

    public abstract void saveGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public abstract void saveRole(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void savePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public abstract Group addGroup(Group var1) throws DataBackendException, EntityExistsException;

    public abstract Role addRole(Role var1) throws DataBackendException, EntityExistsException;

    public abstract Permission addPermission(Permission var1) throws DataBackendException, EntityExistsException;

    public abstract void removeGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public abstract void removeRole(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void removePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public abstract void renameGroup(Group var1, String var2) throws DataBackendException, UnknownEntityException;

    public abstract void renameRole(Role var1, String var2) throws DataBackendException, UnknownEntityException;

    public abstract void renamePermission(Permission var1, String var2) throws DataBackendException, UnknownEntityException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

