/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.ConnectionPool;

public class DBConnection
implements ConnectionEventListener {
    private ConnectionPool pool = null;
    private Connection connection = null;
    private PooledConnection pooledConnection = null;
    private String url = null;
    private String username = null;
    private long timestamp;
    private Vector eventListeners;

    protected void finalize() throws Throwable {
        if (this.pool != null) {
            Log.warn("A DBConnection was finalized, without being returned to the ConnectionPool it belonged to");
            this.connection.close();
            this.pool.releaseConnection(this.pool.getNewConnection());
        }
    }

    protected void link(ConnectionPool pool) {
        if (pool == null) {
            throw new NullPointerException("Cannot link to a null database ConnectionPool");
        }
        this.pool = pool;
        if (this.pooledConnection != null) {
            try {
                if (this.connection == null) {
                    this.connection = this.pooledConnection.getConnection();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void unlink(ConnectionPool pool) throws Exception {
        if (this.pool != pool && pool != null) {
            throw new IllegalArgumentException("Trying to unlink from the wrong pool");
        }
        this.pool = null;
        if (this.pooledConnection != null) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connection = null;
        }
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.pooledConnection != null) {
            this.pooledConnection.addConnectionEventListener(listener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.pooledConnection != null) {
            this.pooledConnection.removeConnectionEventListener(listener);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.pooledConnection != null) {
            if (this.connection != null) {
                return this.connection;
            }
            return this.pooledConnection.getConnection();
        }
        if (this.connection == null) {
            throw new SQLException("Connection object is null!");
        }
        if (this.connection.isClosed()) {
            throw new SQLException("Connection is closed!");
        }
        return this.connection;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    public void setAutoCommit(boolean b) {
        try {
            this.connection.setAutoCommit(b);
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    public Statement createStatement() {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
        return stmt;
    }

    public void close() throws SQLException {
        if (this.pooledConnection != null) {
            this.connection = null;
            this.pooledConnection.removeConnectionEventListener(this);
            this.pooledConnection.close();
            return;
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            String errMsg = "Couldn't close database connection: " + e;
            Log.warn(errMsg);
            throw new SQLException(errMsg);
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        try {
            this.pool.releaseConnection(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred(ConnectionEvent e) {
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            ((PooledConnection)e.getSource()).removeConnectionEventListener(this);
            try {
                ((PooledConnection)e.getSource()).close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (Exception ex) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected DBConnection(Connection connection) {
        this(connection, null, null, null);
    }

    protected DBConnection(Connection connection, String url) {
        this(connection, url, null, null);
    }

    protected DBConnection(Connection connection, String url, String username) {
        this(connection, url, username, null);
    }

    protected DBConnection(Connection connection, String url, String username, ConnectionPool pool) {
        this.connection = connection;
        this.url = url;
        this.username = username;
        this.pool = pool;
        this.timestamp = System.currentTimeMillis();
        this.eventListeners = new Vector();
    }

    protected DBConnection(PooledConnection pooledConnection, String url, String username, ConnectionPool pool) {
        this.pooledConnection = pooledConnection;
        pooledConnection.addConnectionEventListener(this);
        this.url = url;
        this.username = username;
        this.pool = pool;
        this.timestamp = System.currentTimeMillis();
        this.eventListeners = new Vector();
    }
}

