/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.bse.BasisSetEnergy;
import org.scidac.cmcs.tools.bse.BiblioData;
import org.scidac.cmcs.tools.bse.GamessInputToBasisXml;
import org.scidac.cmcs.tools.bse.GaussianInputToBasisXml;
import org.scidac.cmcs.tools.bse.MolproInputToBasisXml;
import org.scidac.cmcs.tools.bse.MolproIntInputToBasisXml;
import org.scidac.cmcs.tools.bse.NWChemInputToBasisXml;

public class BasisSetUpload {
    protected String m_contributionType = "new";
    protected String m_proposedName = "";
    protected String m_bsNameSelect = "";
    protected String m_bsNameSelectURL = "";
    protected String m_ecpNameSelect = "";
    protected String m_format = "NWChem";
    protected String m_harmonicType = "Spherical";
    protected String m_originalFileName = "";
    protected String m_fileContent = "";
    protected String m_description = "";
    protected String m_pi = "";
    protected String m_piEmail = "";
    protected int m_bsCount;
    protected int m_ecpCount;
    protected String m_xmlFileName;
    protected Vector m_xmlVec;
    protected Vector m_xmlFileNameVec;
    protected Vector m_eltVec;
    protected Vector m_references = new Vector();
    protected String m_energyInputMethod;
    protected Vector m_energyTable;
    protected String m_energyFileName;
    protected String m_energyFileContent;
    protected String m_energyComment = "";
    protected String m_summary = "";
    protected String m_noteCurator;

    public BasisSetUpload() {
        this.m_references.add(new BiblioData());
        this.m_xmlFileName = "";
        this.m_xmlVec = new Vector();
        this.m_xmlFileNameVec = new Vector();
        this.m_eltVec = new Vector();
        this.m_energyInputMethod = "noenergy";
        this.m_energyTable = new Vector();
        this.m_energyFileName = "";
        this.m_energyFileContent = "";
        this.m_energyComment = "";
        this.m_noteCurator = "";
    }

    public void parse(String fileName, String fileContent) throws IOException, FormatException {
        this.m_originalFileName = fileName;
        this.m_fileContent = fileContent;
        String bsName = this.m_bsNameSelect;
        String bsURL = this.m_bsNameSelectURL;
        if (this.m_contributionType.equals("new") || this.m_contributionType.equals("newassociateecp")) {
            bsName = this.m_proposedName;
        }
        this.m_xmlFileName = bsName.toUpperCase();
        this.m_xmlFileName = this.m_xmlFileName.replaceAll("[\\s,\\(\\)\\/\\\\]", "");
        this.m_xmlFileName = this.m_xmlFileName.replaceAll("\\*", "S");
        this.m_xmlFileName = this.m_xmlFileName.replaceAll("\\+", "P");
        this.m_bsCount = 0;
        this.m_ecpCount = 0;
        StringBufferInputStream fileStream = new StringBufferInputStream(fileContent);
        AbstractBasisSetToXml converter = null;
        if (this.m_format.equals("NWChem")) {
            converter = new NWChemInputToBasisXml();
        } else if (this.m_format.equals("Gaussian94")) {
            converter = new GaussianInputToBasisXml();
        } else if (this.m_format.equals("GAMESS-US")) {
            converter = new GamessInputToBasisXml();
        } else if (this.m_format.equals("Molpro")) {
            converter = new MolproInputToBasisXml();
        } else if (this.m_format.equals("MOLPRO (Int. Library)")) {
            converter = new MolproIntInputToBasisXml();
        } else {
            throw new FormatException("Unrecognized import type " + this.m_format);
        }
        this.m_xmlVec = converter.convert(bsName, this.m_xmlFileName, this.m_harmonicType, this.m_description, fileStream);
        this.m_xmlFileNameVec = new Vector();
        this.m_eltVec = new Vector();
        for (int i = 0; i < this.m_xmlVec.size(); ++i) {
            Document doc = (Document)this.m_xmlVec.get(i);
            String docType = doc.getRootElement().getName().toLowerCase();
            if (docType.equals("basisset")) {
                String[] types = converter.getContractionTypes(doc);
                if (!types[1].equals("segmented")) {
                    converter.convertToGenerallyContracted(doc);
                    converter.setContractionType(doc, types[1]);
                } else {
                    converter.setContractionType(doc, types[0]);
                }
                AbstractBasisSetToXml.addContractionDescriptions(doc);
                if (this.m_bsCount == 0) {
                    this.m_xmlFileNameVec.add(this.m_xmlFileName + ".xml");
                } else {
                    this.m_xmlFileNameVec.add(this.m_xmlFileName + Integer.toString(this.m_bsCount) + ".xml");
                }
                ++this.m_bsCount;
            } else if (docType.equals("effectivepotentials")) {
                if (this.m_ecpCount == 0) {
                    this.m_xmlFileNameVec.add(this.m_xmlFileName + "-ECP.xml");
                } else {
                    this.m_xmlFileNameVec.add(this.m_xmlFileName + Integer.toString(this.m_ecpCount) + "-ECP.xml");
                }
                ++this.m_ecpCount;
            }
            for (Element elt : ((Document)this.m_xmlVec.elementAt(i)).getRootElement().getChildren()) {
                String eltType;
                if (!elt.getName().equals("contractions") && !elt.getName().equals("potentials") || (eltType = elt.getAttributeValue("elementType")) == null || eltType == "" || this.m_eltVec.contains(eltType)) continue;
                this.m_eltVec.add(eltType);
            }
        }
    }

    public void setContributionType(String contributionType) {
        if (contributionType != null) {
            this.m_contributionType = contributionType;
        }
    }

    public void setProposedName(String proposedName) {
        if (proposedName != null) {
            this.m_proposedName = proposedName;
        }
    }

    public void setBSNameSelect(String bsNameSelect) {
        if (bsNameSelect != null) {
            this.m_bsNameSelect = bsNameSelect;
        }
    }

    public void setBSNameSelectURL(String bsNameSelect) {
        if (bsNameSelect != null) {
            this.m_bsNameSelectURL = bsNameSelect;
        }
    }

    public void setECPNameSelect(String ecpNameSelect) {
        if (ecpNameSelect != null) {
            this.m_ecpNameSelect = ecpNameSelect;
        }
    }

    public void setFormat(String format) {
        if (format != null) {
            this.m_format = format;
        }
    }

    public void setHarmonicTyp(String harmonicType) {
        if (harmonicType != null) {
            this.m_harmonicType = harmonicType;
        }
    }

    public void setOriginalFileName(String originalFileName) {
        if (originalFileName != null) {
            this.m_originalFileName = originalFileName;
        }
    }

    public void setFileContent(String fileContent) {
        if (fileContent != null) {
            this.m_fileContent = fileContent;
        }
    }

    public void setDescription(String description) {
        if (description != null) {
            this.m_description = description;
        }
    }

    public void setPi(String pi) {
        if (pi != null) {
            this.m_pi = pi;
        }
    }

    public void setPiEmail(String piEmail) {
        if (piEmail != null) {
            this.m_piEmail = piEmail;
        }
    }

    public void setSummary(String summary) {
        this.m_summary = summary;
    }

    public void setEnergyInputMethod(String method) {
        this.m_energyInputMethod = method;
    }

    public void addEnergyEntry(String element, String hfenergy, String spin) {
        this.m_energyTable.add(new BasisSetEnergy(element, hfenergy, spin));
    }

    public void clearEnergyTable() {
        this.m_energyTable.clear();
    }

    public void setEnergyFileName(String energyFileName) {
        this.m_energyFileName = energyFileName;
    }

    public void setEnergyFileContent(String energyFileContent) {
        this.m_energyFileContent = energyFileContent;
    }

    public void setEnergyComment(String energyComment) {
        this.m_energyComment = energyComment;
    }

    public void setNoteCurator(String noteCurator) {
        this.m_noteCurator = noteCurator;
    }

    public void addReference() {
        this.m_references.add(new BiblioData());
    }

    public void removeReference() {
        if (this.m_references.size() > 1) {
            this.m_references.remove(this.m_references.size() - 1);
        }
    }

    public void clearReference() {
        this.m_references.clear();
        this.addReference();
    }

    public String getType() {
        return "Gaussian";
    }

    public String getContributionType() {
        return this.m_contributionType;
    }

    public String getProposedName() {
        return this.m_proposedName;
    }

    public String getBSNameSelect() {
        return this.m_bsNameSelect;
    }

    public String getBSNameSelectURL() {
        return this.m_bsNameSelectURL;
    }

    public String getECPNameSelect() {
        return this.m_ecpNameSelect;
    }

    public String getFormat() {
        return this.m_format;
    }

    public String getHarmonicType() {
        return this.m_harmonicType;
    }

    public String getOriginalFileName() {
        return this.m_originalFileName;
    }

    public String getFileContent() {
        return this.m_fileContent;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getPi() {
        return this.m_pi;
    }

    public String getPiEmail() {
        return this.m_piEmail;
    }

    public String getXmlFileName() {
        return this.m_xmlFileName;
    }

    public Vector getReferences() {
        return this.m_references;
    }

    public String[][] getReferenceArray() {
        String[][] ret = new String[this.m_references.size()][8];
        for (int i = 0; i < this.m_references.size(); ++i) {
            BiblioData ref = (BiblioData)this.m_references.elementAt(i);
            ret[i][0] = ref.getElements();
            ret[i][1] = ref.getAuthor();
            ret[i][2] = ref.getTitle();
            ret[i][3] = ref.getJournal();
            int year = ref.getYear();
            ret[i][4] = year != 0 ? Integer.toString(year) : "";
            ret[i][5] = ref.getVolume();
            ret[i][6] = ref.getPages();
            ret[i][7] = "";
        }
        return ret;
    }

    public String getXmlContent() {
        String xmlString = "";
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        for (int i = 0; i < this.m_xmlVec.size(); ++i) {
            xmlString = xmlString + outputter.outputString((Document)this.m_xmlVec.elementAt(i));
        }
        xmlString = xmlString.replaceAll("<", "&lt;");
        xmlString = xmlString.replaceAll(">", "&gt;");
        return xmlString;
    }

    public Vector getXmlVector() {
        return this.m_xmlVec;
    }

    public Vector getXmlFileNameVector() {
        return this.m_xmlFileNameVec;
    }

    public int getNumElements() {
        return this.m_eltVec.size();
    }

    public Vector getElements() {
        return this.m_eltVec;
    }

    public String getEnergyInputMethod() {
        return this.m_energyInputMethod;
    }

    public Vector getEnergy() {
        return this.m_energyTable;
    }

    public BasisSetEnergy getEnergyEntry(String element) {
        for (BasisSetEnergy energy : this.m_energyTable) {
            if (!energy.getElement().equals(element)) continue;
            return energy;
        }
        return null;
    }

    public String getEnergyFileName() {
        return this.m_energyFileName;
    }

    public String getEnergyContent() {
        String ret = "";
        if (this.m_energyInputMethod.equals("energytable")) {
            for (BasisSetEnergy energy : this.m_energyTable) {
                ret = ret + energy.toString();
            }
        } else if (this.m_energyInputMethod.equals("energyfile")) {
            ret = this.m_energyFileContent;
        }
        return ret;
    }

    public String getSummary() {
        return this.m_summary;
    }

    public String getEnergyComment() {
        return this.m_energyComment;
    }

    public String getNoteCurator() {
        return this.m_noteCurator;
    }

    public String getEnergyXmlString() {
        return "";
    }

    public String getBiblioDataXmlString() {
        return "";
    }

    public int getBSCount() {
        return this.m_bsCount;
    }

    public int getECPCount() {
        return this.m_ecpCount;
    }
}

