Package information fields can be overridden per-package:

  $ cat >dune-project <<EOF
  > (lang dune 2.5)
  > (name foo)
  > (version 1.0.0)
  > (source (github mirage/ocaml-cohttp))
  > (license ISC)
  > (authors "Anil Madhavapeddy" "Rudi Grinberg")
  > (homepage https://my.home.page)
  > ;
  > (generate_opam_files true)
  > ;
  > (package
  >  (name foo)
  >  (version 1.0.1)
  >  (source (github mirage/foo))
  >  (license MIT)
  >  (authors "Foo" "Bar"))
  > EOF

  $ dune build @install

  $ cat foo.opam
  # This file is generated by dune, edit dune-project instead
  opam-version: "2.0"
  version: "1.0.1"
  authors: ["Foo" "Bar"]
  license: "MIT"
  homepage: "https://my.home.page"
  bug-reports: "https://github.com/mirage/foo/issues"
  depends: [
    "dune" {>= "2.5"}
  ]
  build: [
    ["dune" "subst"] {pinned}
    [
      "dune"
      "build"
      "-p"
      name
      "-j"
      jobs
      "@install"
      "@runtest" {with-test}
      "@doc" {with-doc}
    ]
  ]
  dev-repo: "git+https://github.com/mirage/foo.git"
