// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2dAPI_PointsToBSpline_HeaderFile
#define _Geom2dAPI_PointsToBSpline_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Approx_ParametrizationType_HeaderFile
#include <Approx_ParametrizationType.hxx>
#endif
class Geom2d_BSplineCurve;
class StdFail_NotDone;
class Standard_OutOfRange;
class TColgp_Array1OfPnt2d;
class TColStd_Array1OfReal;


//! This  class  is  used  to  approximate a  BsplineCurve <br>
//!          passing  through an  array  of points,  with  a  given <br>
//!          Continuity. <br>
//!       Describes functions for building a 2D BSpline <br>
//!       curve which approximates a set of points. <br>
//!       A PointsToBSpline object provides a framework for: <br>
//!       -   defining the data of the BSpline curve to be built, <br>
//!       -   implementing the approximation algorithm, and <br>
//!       -   consulting the results <br>
class Geom2dAPI_PointsToBSpline  {
public:

  DEFINE_STANDARD_ALLOC

  //! Constructs an empty approximation algorithm. <br>
//! Use an Init function to define and build the BSpline curve. <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline();
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline(const TColgp_Array1OfPnt2d& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6);
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  Of coordinates : <br>
//! <br>
//!          X = X0 + DX * (i-YValues.Lower()) <br>
//!          Y = YValues(i) <br>
//! <br>
//!          With i in the range YValues.Lower(), YValues.Upper() <br>
//! <br>
//!          The BSpline will be parametrized  from t = X0 to <br>
//!          X0 + DX * (YValues.Upper() - YValues.Lower()) <br>
//! <br>
//!          And will satisfy X(t) = t <br>
//! <br>
//!          The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline(const TColStd_Array1OfReal& YValues,const Standard_Real X0,const Standard_Real DX,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6);
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline(const TColgp_Array1OfPnt2d& Points,const Approx_ParametrizationType ParType,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-3);
  //! Approximate  a  BSpline  Curve  passing through an <br>
//!          array of Point,  which parameters are given by the <br>
//!           array <Parameters>. <br>
//!          The resulting  BSpline   will have the   following <br>
//!          properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline(const TColgp_Array1OfPnt2d& Points,const TColStd_Array1OfReal& Parameters,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-3);
  //! Approximate a BSpline Curve  passing through an <br>
//!          array of Point using variational smoothing algorithm, <br>
//!          which tries to minimize additional criterium: <br>
//!          Weight1*CurveLength + Weight2*Curvature + Weight3*Torsion <br>
  Standard_EXPORT   Geom2dAPI_PointsToBSpline(const TColgp_Array1OfPnt2d& Points,const Standard_Real Weight1,const Standard_Real Weight2,const Standard_Real Weight3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol3D = 1.0e-3);
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT     void Init(const TColgp_Array1OfPnt2d& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6) ;
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  Of coordinates : <br>
//! <br>
//!          X = X0 + DX * (i-YValues.Lower()) <br>
//!          Y = YValues(i) <br>
//! <br>
//!          With i in the range YValues.Lower(), YValues.Upper() <br>
//! <br>
//!          The BSpline will be parametrized  from t = X0 to <br>
//!          X0 + DX * (YValues.Upper() - YValues.Lower()) <br>
//! <br>
//!          And will satisfy X(t) = t <br>
//! <br>
//!          The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT     void Init(const TColStd_Array1OfReal& YValues,const Standard_Real X0,const Standard_Real DX,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6) ;
  //! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT     void Init(const TColgp_Array1OfPnt2d& Points,const Approx_ParametrizationType ParType,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-3) ;
  //! Approximate  a  BSpline  Curve  passing through an <br>
//!          array of Point,  which parameters are given by the <br>
//!           array <Parameters>. <br>
//!          The resulting  BSpline   will have the   following <br>
//!          properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
  Standard_EXPORT     void Init(const TColgp_Array1OfPnt2d& Points,const TColStd_Array1OfReal& Parameters,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-3) ;
  //! Approximate a BSpline Curve  passing through an <br>
//!          array of Point using variational smoothing algorithm, <br>
//!          which tries to minimize additional criterium: <br>
//!          Weight1*CurveLength + Weight2*Curvature + Weight3*Torsion <br>
  Standard_EXPORT     void Init(const TColgp_Array1OfPnt2d& Points,const Standard_Real Weight1,const Standard_Real Weight2,const Standard_Real Weight3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-3) ;
  //! Returns the approximate BSpline Curve <br>
  Standard_EXPORT    const Handle_Geom2d_BSplineCurve& Curve() const;
Standard_EXPORT operator Handle(Geom2d_BSplineCurve)() const;
  
  Standard_EXPORT     Standard_Boolean IsDone() const;





protected:





private:



Standard_Boolean myIsDone;
Handle_Geom2d_BSplineCurve myCurve;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
