#
# Author:: Thom May (<thom@clearairturbulence.org>)
# Copyright:: Copyright (c) 2008-2016 Chef Software, Inc.
# License:: Apache License, Version 2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

Ohai.plugin(:Python) do
  provides "languages/python"

  depends "languages"

  collect_data do

    so = shell_out("python -c \"import sys; print (sys.version)\"")
    # Sample output:
    # 2.7.11 (default, Dec 26 2015, 17:47:53)
    # [GCC 4.2.1 Compatible Apple LLVM 7.0.2 (clang-700.1.81)]
    if so.exitstatus == 0
      python = Mash.new
      output = so.stdout.split
      python[:version] = output[0]
      if output.length >= 6
        python[:builddate] = "%s %s %s %s" % [output[2], output[3], output[4], output[5].delete!(")")]
      end
      languages[:python] = python unless python.empty?
    end
  rescue Ohai::Exceptions::Exec
    logger.trace('Plugin Python: Could not shell_out "python -c "import sys; print (sys.version)"". Skipping plugin')

  end
end
