/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "touch.h"

#include "attributes.h"

using geis_attributes::PopulateAttributeMap;

Touch::Touch() {
}

void Touch::Initialize(GeisTouch touch) {
  attributes_.clear();
  PopulateAttributeMap< GeisTouch >(touch, &attributes_);

  id_ = attributes_[GEIS_TOUCH_ATTRIBUTE_ID].toInt();

  GeisFloat x = attributes_[GEIS_TOUCH_ATTRIBUTE_X].toFloat();
  GeisFloat y = attributes_[GEIS_TOUCH_ATTRIBUTE_Y].toFloat();
  location_ = QPointF(x, y);
}
