#!/bin/bash
###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $4 $6/mof/OpenDRIM_RegisteredBatteryProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_RegisteredBatteryProfile provider module";
Name = "Battery_OpenDRIM_RegisteredBatteryProfileModule";
Location = "cmpiBattery_OpenDRIM_RegisteredBatteryProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_RegisteredBatteryProfile provider";
Name = "Battery_OpenDRIM_RegisteredBatteryProfileProvider";
ProviderModuleName = "Battery_OpenDRIM_RegisteredBatteryProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_RegisteredBatteryProfile provider capabilities";
ProviderModuleName = "Battery_OpenDRIM_RegisteredBatteryProfileModule";
ProviderName = "Battery_OpenDRIM_RegisteredBatteryProfileProvider";
ClassName = "OpenDRIM_RegisteredBatteryProfile";
ProviderType = {2};
Namespaces = {"$4"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID", "RegisteredOrganization", "OtherRegisteredOrganization", "RegisteredName", "RegisteredVersion", "AdvertiseTypes", "AdvertiseTypeDescriptions"};
CapabilityID = "Battery_OpenDRIM_RegisteredBatteryProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_RegisteredBatteryProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_RegisteredBatteryProfile]   
   provider: Battery_OpenDRIM_RegisteredBatteryProfileProvider
   location: cmpiBattery_OpenDRIM_RegisteredBatteryProfileProvider
   type: instance
   namespace: $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_RegisteredBatteryProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_RegisteredBatteryProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_RegisteredBatteryProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
