/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMBEROFPOWERSUPPLYCOLLECTIONACCESS_H_
#define OPENDRIM_MEMBEROFPOWERSUPPLYCOLLECTIONACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_MemberOfPowerSupplyCollection.h"
#include "assocOpenDRIM_MemberOfPowerSupplyCollection.h"

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_unload(string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemberOfPowerSupplyCollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemberOfPowerSupplyCollection& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& newInstance, const OpenDRIM_MemberOfPowerSupplyCollection& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_MemberOfPowerSupplyCollection>& OpenDRIM_MemberOfPowerSupplyCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_MemberOfPowerSupplyCollection>& OpenDRIM_MemberOfPowerSupplyCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_MemberOfPowerSupplyCollection_populate(OpenDRIM_MemberOfPowerSupplyCollection& instance, string& errorMessage);

#endif /*OPENDRIM_MEMBEROFPOWERSUPPLYCOLLECTIONACCESS_H_*/
