/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_MEMBEROFAVAILABLESOFTWARECOLLECTIONACCESS_H_
#define OPENDRIM_MEMBEROFAVAILABLESOFTWARECOLLECTIONACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_MemberOfAvailableSoftwareCollection.h"
#include "assocOpenDRIM_MemberOfAvailableSoftwareCollection.h"

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemberOfAvailableSoftwareCollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemberOfAvailableSoftwareCollection& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfAvailableSoftwareCollection& newInstance, const OpenDRIM_MemberOfAvailableSoftwareCollection& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfAvailableSoftwareCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemberOfAvailableSoftwareCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_MemberOfAvailableSoftwareCollection>& OpenDRIM_MemberOfAvailableSoftwareCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_MemberOfAvailableSoftwareCollection>& OpenDRIM_MemberOfAvailableSoftwareCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_MemberOfAvailableSoftwareCollection_populate(OpenDRIM_MemberOfAvailableSoftwareCollection& instance, string& errorMessage);

#endif /*OPENDRIM_MEMBEROFAVAILABLESOFTWARECOLLECTIONACCESS_H_*/
