!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 1986, Per E. M. Siegbahn                               *
!               1986, Margareta R. A. Blomberg                         *
!***********************************************************************

subroutine DSQ2(C,S,MUL,INDX,JSY,NDIAG,INUM,IRC3,LSYM,NVIRT,SQ2)

use Definitions, only: wp, iwp

implicit none
real(kind=wp), intent(inout) :: C(*), S(*)
integer(kind=iwp), intent(in) :: MUL(8,8), INDX(*), JSY(*), NDIAG(*), INUM, IRC3, LSYM, NVIRT
real(kind=wp), intent(in) :: SQ2
integer(kind=iwp) :: I, II1, MA, NA, NS1, NS1L
integer(kind=iwp), external :: JSUNP

do I=1,INUM
  II1 = IRC3+I
  NS1 = JSUNP(JSY,II1)
  NS1L = MUL(NS1,LSYM)
  if (NS1L /= 1) cycle
  NA = INDX(II1)
  do MA=1,NVIRT
    C(NA+NDIAG(MA)) = C(NA+NDIAG(MA))/SQ2
    S(NA+NDIAG(MA)) = SQ2*S(NA+NDIAG(MA))
  end do
end do

return

end subroutine DSQ2
