!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!***********************************************************************

subroutine Chck_Energ()
! calc energy from T1c and t2c

use chcc_global, only: no, nv, Q21, T1c, T2c
use Constants, only: Zero, Two
use Definitions, only: wp, iwp, u6

implicit none
integer(kind=iwp) :: a, b, i, j
real(kind=wp) :: e

e = Zero

do j=1,no
  do i=1,no
    do b=1,nv
      do a=1,nv
        e = e+(Two*Q21(a,i,b,j)-Q21(a,j,b,i))*(T2c(a,b,i,j)+T1c(a,i)*T1c(b,j))
      end do
    end do
  end do
end do

write(u6,*) ' Energia Checkeroo',e

return

end subroutine Chck_Energ
