/**********************************************************************
 *
 *    FILE:            CullFace.cpp
 *
 *    DESCRIPTION:    Read/Write osg::CullFace in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 27.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "CullFace.h"
#include "Object.h"

using namespace ive;

void CullFace::write(DataOutputStream* out){
    // Write CullFace's identification.
    out->writeInt(IVECULLFACE);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("CullFace::write(): Could not cast this osg::CullFace to an osg::Object.");
    // Write CullFace's properties.
    out->writeInt(getMode());
}

void CullFace::read(DataInputStream* in){
    // Peek on CullFace's identification.
    int id = in->peekInt();
    if(id == IVECULLFACE){
        // Read CullFace's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("CullFace::read(): Could not cast this osg::CullFace to an osg::Object.");
        // Read CullFace's properties
        setMode((osg::CullFace::Mode)in->readInt());
    }
    else{
        in_THROW_EXCEPTION("CullFace::read(): Expected CullFace identification.");
    }
}
