/**********************************************************************
 *
 *    FILE:            Impostor.cpp
 *
 *    DESCRIPTION:    Read/Write osg::Impostor in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 16.4.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Impostor.h"
#include "LOD.h"

using namespace ive;

void Impostor::write(DataOutputStream* out){
    // Write Impostor's identification.
    out->writeInt(IVEIMPOSTOR);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::LOD*  lod = dynamic_cast<osg::LOD*>(this);
    if(lod){
        ((ive::LOD*)(lod))->write(out);
    }
    else
        out_THROW_EXCEPTION("Impostor::write(): Could not cast this osg::Impostor to an osg::LOD.");
    // Write Impostor's properties.
    out->writeFloat(getImpostorThreshold());
}

void Impostor::read(DataInputStream* in){
    // Peek on Impostor's identification.
    int id = in->peekInt();
    if(id == IVEIMPOSTOR){
        // Read Impostor's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::LOD*  lod = dynamic_cast<osg::LOD*>(this);
        if(lod){
            ((ive::LOD*)(lod))->read(in);
        }
        else
            in_THROW_EXCEPTION("Impostor::read(): Could not cast this osg::Impostor to an osg::LOD.");
        // Read Impostor's properties
        setImpostorThreshold(in->readFloat());
    }
    else{
        in_THROW_EXCEPTION("Impostor::read(): Expected Impostor identification.");
    }
}
