
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .Definitions import *
from .AttributeValue import AttributeValue


class GlobalDefWriter(ctypes.Structure):
    pass

def GlobalDefWriter_GetNumberOfDefinitions(writerHandle, numberOfDefinitions = ctypes.c_uint64()):
    c_GetNumberOfDefinitions = conf.lib.OTF2_GlobalDefWriter_GetNumberOfDefinitions
    c_GetNumberOfDefinitions.argtypes = [ ctypes.POINTER(GlobalDefWriter), ctypes.POINTER(ctypes.c_uint64) ]
    c_GetNumberOfDefinitions.restype = ErrorCode
    c_GetNumberOfDefinitions.errcheck = HandleErrorCode
    c_GetNumberOfDefinitions(writerHandle, ctypes.byref(numberOfDefinitions))
    return numberOfDefinitions.value

def GlobalDefWriter_GetNumberOfLocations(writerHandle, numberOfLocations = ctypes.c_uint64()):
    c_GetNumberOfLocations = conf.lib.OTF2_GlobalDefWriter_GetNumberOfLocations
    c_GetNumberOfLocations.argtypes = [ ctypes.POINTER(GlobalDefWriter), ctypes.POINTER(ctypes.c_uint64) ]
    c_GetNumberOfLocations.restype = ErrorCode
    c_GetNumberOfLocations.errcheck = HandleErrorCode
    c_GetNumberOfLocations(writerHandle, ctypes.byref(numberOfLocations))
    return numberOfLocations.value

def GlobalDefWriter_WriteClockProperties(writerHandle, timerResolution, globalOffset, traceLength, realtimeTimestamp):
    c_WriteClockProperties = conf.lib.OTF2_GlobalDefWriter_WriteClockProperties
    c_WriteClockProperties.argtypes = [ ctypes.POINTER(GlobalDefWriter), ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64 ]
    c_WriteClockProperties.restype = ErrorCode
    c_WriteClockProperties.errcheck = HandleErrorCode
    c_WriteClockProperties(writerHandle, timerResolution, globalOffset, traceLength, realtimeTimestamp)

def GlobalDefWriter_WriteMappingTable(writerHandle, mappingType, idMap):
    c_WriteMappingTable = conf.lib.OTF2_GlobalDefWriter_WriteMappingTable
    c_WriteMappingTable.argtypes = [ ctypes.POINTER(GlobalDefWriter), MappingType, ctypes.POINTER(IdMap) ]
    c_WriteMappingTable.restype = ErrorCode
    c_WriteMappingTable.errcheck = HandleErrorCode
    c_WriteMappingTable(writerHandle, mappingType, idMap)

def GlobalDefWriter_WriteClockOffset(writerHandle, time, offset, standardDeviation):
    c_WriteClockOffset = conf.lib.OTF2_GlobalDefWriter_WriteClockOffset
    c_WriteClockOffset.argtypes = [ ctypes.POINTER(GlobalDefWriter), TimeStamp, ctypes.c_int64, ctypes.c_double ]
    c_WriteClockOffset.restype = ErrorCode
    c_WriteClockOffset.errcheck = HandleErrorCode
    c_WriteClockOffset(writerHandle, time, offset, standardDeviation)

def GlobalDefWriter_WriteParadigm(writerHandle, paradigm, name, paradigmClass):
    c_WriteParadigm = conf.lib.OTF2_GlobalDefWriter_WriteParadigm
    c_WriteParadigm.argtypes = [ ctypes.POINTER(GlobalDefWriter), Paradigm, StringRef, ParadigmClass ]
    c_WriteParadigm.restype = ErrorCode
    c_WriteParadigm.errcheck = HandleErrorCode
    c_WriteParadigm(writerHandle, paradigm, name, paradigmClass)

def GlobalDefWriter_WriteParadigmProperty(writerHandle, paradigm, property, type, value):
    c_WriteParadigmProperty = conf.lib.OTF2_GlobalDefWriter_WriteParadigmProperty
    c_WriteParadigmProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), Paradigm, ParadigmProperty, Type, AttributeValue._arg_type ]
    c_WriteParadigmProperty.restype = ErrorCode
    c_WriteParadigmProperty.errcheck = HandleErrorCode
    c_WriteParadigmProperty(writerHandle, paradigm, property, type, value._arg_value)

def GlobalDefWriter_WriteIoParadigm(writerHandle, self, identification, name, ioParadigmClass, ioParadigmFlags, properties, types, values):
    numberOfProperties = len(properties)
    assert numberOfProperties == len(types) == len(values)
    properties_array = (IoParadigmProperty * numberOfProperties)()
    properties_array[:] = properties
    types_array = (Type * numberOfProperties)()
    types_array[:] = types
    values_array = (AttributeValue * numberOfProperties)()
    values_array[:] = values

    c_WriteIoParadigm = conf.lib.OTF2_GlobalDefWriter_WriteIoParadigm
    c_WriteIoParadigm.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoParadigmRef, StringRef, StringRef, IoParadigmClass, IoParadigmFlag, ctypes.c_uint8, ctypes.POINTER(IoParadigmProperty), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_WriteIoParadigm.restype = ErrorCode
    c_WriteIoParadigm.errcheck = HandleErrorCode
    c_WriteIoParadigm(writerHandle, self, identification, name, ioParadigmClass, ioParadigmFlags,
                      numberOfProperties, properties_array, types_array, values_array)

def GlobalDefWriter_WriteString(writerHandle, self, string):
    c_WriteString = conf.lib.OTF2_GlobalDefWriter_WriteString
    c_WriteString.argtypes = [ ctypes.POINTER(GlobalDefWriter), StringRef, StrParam ]
    c_WriteString.restype = ErrorCode
    c_WriteString.errcheck = HandleErrorCode
    c_WriteString(writerHandle, self, string)

def GlobalDefWriter_WriteAttribute(writerHandle, self, name, description, type):
    c_WriteAttribute = conf.lib.OTF2_GlobalDefWriter_WriteAttribute
    c_WriteAttribute.argtypes = [ ctypes.POINTER(GlobalDefWriter), AttributeRef, StringRef, StringRef, Type ]
    c_WriteAttribute.restype = ErrorCode
    c_WriteAttribute.errcheck = HandleErrorCode
    c_WriteAttribute(writerHandle, self, name, description, type)

def GlobalDefWriter_WriteSystemTreeNode(writerHandle, self, name, className, parent):
    c_WriteSystemTreeNode = conf.lib.OTF2_GlobalDefWriter_WriteSystemTreeNode
    c_WriteSystemTreeNode.argtypes = [ ctypes.POINTER(GlobalDefWriter), SystemTreeNodeRef, StringRef, StringRef, SystemTreeNodeRef ]
    c_WriteSystemTreeNode.restype = ErrorCode
    c_WriteSystemTreeNode.errcheck = HandleErrorCode
    c_WriteSystemTreeNode(writerHandle, self, name, className, parent)

def GlobalDefWriter_WriteLocationGroup(writerHandle, self, name, locationGroupType, systemTreeParent, creatingLocationGroup):
    c_WriteLocationGroup = conf.lib.OTF2_GlobalDefWriter_WriteLocationGroup
    c_WriteLocationGroup.argtypes = [ ctypes.POINTER(GlobalDefWriter), LocationGroupRef, StringRef, LocationGroupType, SystemTreeNodeRef, LocationGroupRef ]
    c_WriteLocationGroup.restype = ErrorCode
    c_WriteLocationGroup.errcheck = HandleErrorCode
    c_WriteLocationGroup(writerHandle, self, name, locationGroupType, systemTreeParent, creatingLocationGroup)

def GlobalDefWriter_WriteLocation(writerHandle, self, name, locationType, numberOfEvents, locationGroup):
    c_WriteLocation = conf.lib.OTF2_GlobalDefWriter_WriteLocation
    c_WriteLocation.argtypes = [ ctypes.POINTER(GlobalDefWriter), LocationRef, StringRef, LocationType, ctypes.c_uint64, LocationGroupRef ]
    c_WriteLocation.restype = ErrorCode
    c_WriteLocation.errcheck = HandleErrorCode
    c_WriteLocation(writerHandle, self, name, locationType, numberOfEvents, locationGroup)

def GlobalDefWriter_WriteRegion(writerHandle, self, name, canonicalName, description, regionRole, paradigm, regionFlags, sourceFile, beginLineNumber, endLineNumber):
    c_WriteRegion = conf.lib.OTF2_GlobalDefWriter_WriteRegion
    c_WriteRegion.argtypes = [ ctypes.POINTER(GlobalDefWriter), RegionRef, StringRef, StringRef, StringRef, RegionRole, Paradigm, RegionFlag, StringRef, ctypes.c_uint32, ctypes.c_uint32 ]
    c_WriteRegion.restype = ErrorCode
    c_WriteRegion.errcheck = HandleErrorCode
    c_WriteRegion(writerHandle, self, name, canonicalName, description, regionRole, paradigm, regionFlags, sourceFile, beginLineNumber, endLineNumber)

def GlobalDefWriter_WriteCallsite(writerHandle, self, sourceFile, lineNumber, enteredRegion, leftRegion):
    c_WriteCallsite = conf.lib.OTF2_GlobalDefWriter_WriteCallsite
    c_WriteCallsite.argtypes = [ ctypes.POINTER(GlobalDefWriter), CallsiteRef, StringRef, ctypes.c_uint32, RegionRef, RegionRef ]
    c_WriteCallsite.restype = ErrorCode
    c_WriteCallsite.errcheck = HandleErrorCode
    c_WriteCallsite(writerHandle, self, sourceFile, lineNumber, enteredRegion, leftRegion)

def GlobalDefWriter_WriteCallpath(writerHandle, self, parent, region):
    c_WriteCallpath = conf.lib.OTF2_GlobalDefWriter_WriteCallpath
    c_WriteCallpath.argtypes = [ ctypes.POINTER(GlobalDefWriter), CallpathRef, CallpathRef, RegionRef ]
    c_WriteCallpath.restype = ErrorCode
    c_WriteCallpath.errcheck = HandleErrorCode
    c_WriteCallpath(writerHandle, self, parent, region)

def GlobalDefWriter_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, members):
    numberOfMembers = len(members)
    array_type = ctypes.c_uint64 * numberOfMembers
    members_array = array_type()
    members_array[:] = members

    c_WriteGroup = conf.lib.OTF2_GlobalDefWriter_WriteGroup
    c_WriteGroup.argtypes = [ ctypes.POINTER(GlobalDefWriter), GroupRef, StringRef, GroupType, Paradigm, GroupFlag,
                              ctypes.c_uint32, array_type ]
    c_WriteGroup.restype = ErrorCode
    c_WriteGroup.errcheck = HandleErrorCode
    c_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, numberOfMembers, members_array)

def GlobalDefWriter_WriteMetricMember(writerHandle, self, name, description, metricType, metricMode, valueType, base, exponent, unit):
    c_WriteMetricMember = conf.lib.OTF2_GlobalDefWriter_WriteMetricMember
    c_WriteMetricMember.argtypes = [ ctypes.POINTER(GlobalDefWriter), MetricMemberRef, StringRef, StringRef, MetricType, MetricMode, Type, Base, ctypes.c_int64, StringRef ]
    c_WriteMetricMember.restype = ErrorCode
    c_WriteMetricMember.errcheck = HandleErrorCode
    c_WriteMetricMember(writerHandle, self, name, description, metricType, metricMode, valueType, base, exponent, unit)

def GlobalDefWriter_WriteMetricClass(writerHandle, self, metricMembers, metricOccurrence, recorderKind):
    numberOfMetrics = len(metricMembers)
    array_type = MetricMemberRef * numberOfMetrics
    metric_member_array = array_type()
    metric_member_array[:] = metricMembers

    c_WriteMetricClass = conf.lib.OTF2_GlobalDefWriter_WriteMetricClass
    c_WriteMetricClass.argtypes = [ ctypes.POINTER(GlobalDefWriter), MetricRef, ctypes.c_uint8, array_type,
                                    MetricOccurrence, RecorderKind ]
    c_WriteMetricClass.restype = ErrorCode
    c_WriteMetricClass.errcheck = HandleErrorCode
    c_WriteMetricClass(writerHandle, MetricRef(self), numberOfMetrics, metric_member_array,
                       metricOccurrence, recorderKind)

def GlobalDefWriter_WriteMetricInstance(writerHandle, self, metricClass, recorder, metricScope, scope):
    c_WriteMetricInstance = conf.lib.OTF2_GlobalDefWriter_WriteMetricInstance
    c_WriteMetricInstance.argtypes = [ ctypes.POINTER(GlobalDefWriter), MetricRef, MetricRef, LocationRef, MetricScope, ctypes.c_uint64 ]
    c_WriteMetricInstance.restype = ErrorCode
    c_WriteMetricInstance.errcheck = HandleErrorCode
    c_WriteMetricInstance(writerHandle, self, metricClass, recorder, metricScope, scope)

def GlobalDefWriter_WriteComm(writerHandle, self, name, group, parent, flags):
    c_WriteComm = conf.lib.OTF2_GlobalDefWriter_WriteComm
    c_WriteComm.argtypes = [ ctypes.POINTER(GlobalDefWriter), CommRef, StringRef, GroupRef, CommRef, CommFlag ]
    c_WriteComm.restype = ErrorCode
    c_WriteComm.errcheck = HandleErrorCode
    c_WriteComm(writerHandle, self, name, group, parent, flags)

def GlobalDefWriter_WriteParameter(writerHandle, self, name, parameterType):
    c_WriteParameter = conf.lib.OTF2_GlobalDefWriter_WriteParameter
    c_WriteParameter.argtypes = [ ctypes.POINTER(GlobalDefWriter), ParameterRef, StringRef, ParameterType ]
    c_WriteParameter.restype = ErrorCode
    c_WriteParameter.errcheck = HandleErrorCode
    c_WriteParameter(writerHandle, self, name, parameterType)

def GlobalDefWriter_WriteRmaWin(writerHandle, self, name, comm, flags):
    c_WriteRmaWin = conf.lib.OTF2_GlobalDefWriter_WriteRmaWin
    c_WriteRmaWin.argtypes = [ ctypes.POINTER(GlobalDefWriter), RmaWinRef, StringRef, CommRef, RmaWinFlag ]
    c_WriteRmaWin.restype = ErrorCode
    c_WriteRmaWin.errcheck = HandleErrorCode
    c_WriteRmaWin(writerHandle, self, name, comm, flags)

def GlobalDefWriter_WriteMetricClassRecorder(writerHandle, metric, recorder):
    c_WriteMetricClassRecorder = conf.lib.OTF2_GlobalDefWriter_WriteMetricClassRecorder
    c_WriteMetricClassRecorder.argtypes = [ ctypes.POINTER(GlobalDefWriter), MetricRef, LocationRef ]
    c_WriteMetricClassRecorder.restype = ErrorCode
    c_WriteMetricClassRecorder.errcheck = HandleErrorCode
    c_WriteMetricClassRecorder(writerHandle, metric, recorder)

def GlobalDefWriter_WriteSystemTreeNodeProperty(writerHandle, systemTreeNode, name, type, value):
    c_WriteSystemTreeNodeProperty = conf.lib.OTF2_GlobalDefWriter_WriteSystemTreeNodeProperty
    c_WriteSystemTreeNodeProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), SystemTreeNodeRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteSystemTreeNodeProperty.restype = ErrorCode
    c_WriteSystemTreeNodeProperty.errcheck = HandleErrorCode
    c_WriteSystemTreeNodeProperty(writerHandle, systemTreeNode, name, type, value._arg_value)

def GlobalDefWriter_WriteSystemTreeNodeDomain(writerHandle, systemTreeNode, systemTreeDomain):
    c_WriteSystemTreeNodeDomain = conf.lib.OTF2_GlobalDefWriter_WriteSystemTreeNodeDomain
    c_WriteSystemTreeNodeDomain.argtypes = [ ctypes.POINTER(GlobalDefWriter), SystemTreeNodeRef, SystemTreeDomain ]
    c_WriteSystemTreeNodeDomain.restype = ErrorCode
    c_WriteSystemTreeNodeDomain.errcheck = HandleErrorCode
    c_WriteSystemTreeNodeDomain(writerHandle, systemTreeNode, systemTreeDomain)

def GlobalDefWriter_WriteLocationGroupProperty(writerHandle, locationGroup, name, type, value):
    c_WriteLocationGroupProperty = conf.lib.OTF2_GlobalDefWriter_WriteLocationGroupProperty
    c_WriteLocationGroupProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), LocationGroupRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteLocationGroupProperty.restype = ErrorCode
    c_WriteLocationGroupProperty.errcheck = HandleErrorCode
    c_WriteLocationGroupProperty(writerHandle, locationGroup, name, type, value._arg_value)

def GlobalDefWriter_WriteLocationProperty(writerHandle, location, name, type, value):
    c_WriteLocationProperty = conf.lib.OTF2_GlobalDefWriter_WriteLocationProperty
    c_WriteLocationProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), LocationRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteLocationProperty.restype = ErrorCode
    c_WriteLocationProperty.errcheck = HandleErrorCode
    c_WriteLocationProperty(writerHandle, location, name, type, value._arg_value)

def GlobalDefWriter_WriteCartDimension(writerHandle, self, name, size, cartPeriodicity):
    c_WriteCartDimension = conf.lib.OTF2_GlobalDefWriter_WriteCartDimension
    c_WriteCartDimension.argtypes = [ ctypes.POINTER(GlobalDefWriter), CartDimensionRef, StringRef, ctypes.c_uint32, CartPeriodicity ]
    c_WriteCartDimension.restype = ErrorCode
    c_WriteCartDimension.errcheck = HandleErrorCode
    c_WriteCartDimension(writerHandle, self, name, size, cartPeriodicity)

def GlobalDefWriter_WriteCartTopology(writerHandle, self, name, communicator, cartDimensions):
    numberOfDimensions = len(cartDimensions)
    array_type = CartDimensionRef * numberOfDimensions
    cart_dimensions_array = array_type()
    cart_dimensions_array[:] = cartDimensions

    c_WriteCartTopology = conf.lib.OTF2_GlobalDefWriter_WriteCartTopology
    c_WriteCartTopology.argtypes = [ ctypes.POINTER(GlobalDefWriter), CartTopologyRef, StringRef, CommRef,
                                     ctypes.c_uint8, array_type ]
    c_WriteCartTopology.restype = ErrorCode
    c_WriteCartTopology.errcheck = HandleErrorCode
    c_WriteCartTopology(writerHandle, self, name, communicator, numberOfDimensions, cart_dimensions_array)

def GlobalDefWriter_WriteCartCoordinate(writerHandle, cartTopology, rank, coordinates):
    numberOfDimensions = len(coordinates)
    array_type = ctypes.c_uint32 * numberOfDimensions
    coordinates_array = array_type()
    coordinates_array[:] = coordinates

    c_WriteCartCoordinate = conf.lib.OTF2_GlobalDefWriter_WriteCartCoordinate
    c_WriteCartCoordinate.argtypes = [ ctypes.POINTER(GlobalDefWriter), CartTopologyRef, ctypes.c_uint32,
                                       ctypes.c_uint8, array_type ]
    c_WriteCartCoordinate.restype = ErrorCode
    c_WriteCartCoordinate.errcheck = HandleErrorCode
    c_WriteCartCoordinate(writerHandle, cartTopology, rank, numberOfDimensions, coordinates_array)

def GlobalDefWriter_WriteSourceCodeLocation(writerHandle, self, file, lineNumber):
    c_WriteSourceCodeLocation = conf.lib.OTF2_GlobalDefWriter_WriteSourceCodeLocation
    c_WriteSourceCodeLocation.argtypes = [ ctypes.POINTER(GlobalDefWriter), SourceCodeLocationRef, StringRef, ctypes.c_uint32 ]
    c_WriteSourceCodeLocation.restype = ErrorCode
    c_WriteSourceCodeLocation.errcheck = HandleErrorCode
    c_WriteSourceCodeLocation(writerHandle, self, file, lineNumber)

def GlobalDefWriter_WriteCallingContext(writerHandle, self, region, sourceCodeLocation, parent):
    c_WriteCallingContext = conf.lib.OTF2_GlobalDefWriter_WriteCallingContext
    c_WriteCallingContext.argtypes = [ ctypes.POINTER(GlobalDefWriter), CallingContextRef, RegionRef, SourceCodeLocationRef, CallingContextRef ]
    c_WriteCallingContext.restype = ErrorCode
    c_WriteCallingContext.errcheck = HandleErrorCode
    c_WriteCallingContext(writerHandle, self, region, sourceCodeLocation, parent)

def GlobalDefWriter_WriteCallingContextProperty(writerHandle, callingContext, name, type, value):
    c_WriteCallingContextProperty = conf.lib.OTF2_GlobalDefWriter_WriteCallingContextProperty
    c_WriteCallingContextProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), CallingContextRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteCallingContextProperty.restype = ErrorCode
    c_WriteCallingContextProperty.errcheck = HandleErrorCode
    c_WriteCallingContextProperty(writerHandle, callingContext, name, type, value._arg_value)

def GlobalDefWriter_WriteInterruptGenerator(writerHandle, self, name, interruptGeneratorMode, base, exponent, period):
    c_WriteInterruptGenerator = conf.lib.OTF2_GlobalDefWriter_WriteInterruptGenerator
    c_WriteInterruptGenerator.argtypes = [ ctypes.POINTER(GlobalDefWriter), InterruptGeneratorRef, StringRef, InterruptGeneratorMode, Base, ctypes.c_int64, ctypes.c_uint64 ]
    c_WriteInterruptGenerator.restype = ErrorCode
    c_WriteInterruptGenerator.errcheck = HandleErrorCode
    c_WriteInterruptGenerator(writerHandle, self, name, interruptGeneratorMode, base, exponent, period)

def GlobalDefWriter_WriteIoFileProperty(writerHandle, ioFile, name, type, value):
    c_WriteIoFileProperty = conf.lib.OTF2_GlobalDefWriter_WriteIoFileProperty
    c_WriteIoFileProperty.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoFileRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteIoFileProperty.restype = ErrorCode
    c_WriteIoFileProperty.errcheck = HandleErrorCode
    c_WriteIoFileProperty(writerHandle, ioFile, name, type, value._arg_value)

def GlobalDefWriter_WriteIoRegularFile(writerHandle, self, name, scope):
    c_WriteIoRegularFile = conf.lib.OTF2_GlobalDefWriter_WriteIoRegularFile
    c_WriteIoRegularFile.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoFileRef, StringRef, SystemTreeNodeRef ]
    c_WriteIoRegularFile.restype = ErrorCode
    c_WriteIoRegularFile.errcheck = HandleErrorCode
    c_WriteIoRegularFile(writerHandle, self, name, scope)

def GlobalDefWriter_WriteIoDirectory(writerHandle, self, name, scope):
    c_WriteIoDirectory = conf.lib.OTF2_GlobalDefWriter_WriteIoDirectory
    c_WriteIoDirectory.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoFileRef, StringRef, SystemTreeNodeRef ]
    c_WriteIoDirectory.restype = ErrorCode
    c_WriteIoDirectory.errcheck = HandleErrorCode
    c_WriteIoDirectory(writerHandle, self, name, scope)

def GlobalDefWriter_WriteIoHandle(writerHandle, self, name, file, ioParadigm, ioHandleFlags, comm, parent):
    c_WriteIoHandle = conf.lib.OTF2_GlobalDefWriter_WriteIoHandle
    c_WriteIoHandle.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoHandleRef, StringRef, IoFileRef, IoParadigmRef, IoHandleFlag, CommRef, IoHandleRef ]
    c_WriteIoHandle.restype = ErrorCode
    c_WriteIoHandle.errcheck = HandleErrorCode
    c_WriteIoHandle(writerHandle, self, name, file, ioParadigm, ioHandleFlags, comm, parent)

def GlobalDefWriter_WriteIoPreCreatedHandleState(writerHandle, ioHandle, mode, statusFlags):
    c_WriteIoPreCreatedHandleState = conf.lib.OTF2_GlobalDefWriter_WriteIoPreCreatedHandleState
    c_WriteIoPreCreatedHandleState.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoHandleRef, IoAccessMode, IoStatusFlag ]
    c_WriteIoPreCreatedHandleState.restype = ErrorCode
    c_WriteIoPreCreatedHandleState.errcheck = HandleErrorCode
    c_WriteIoPreCreatedHandleState(writerHandle, ioHandle, mode, statusFlags)

def GlobalDefWriter_WriteCallpathParameter(writerHandle, callpath, parameter, type, value):
    c_WriteCallpathParameter = conf.lib.OTF2_GlobalDefWriter_WriteCallpathParameter
    c_WriteCallpathParameter.argtypes = [ ctypes.POINTER(GlobalDefWriter), CallpathRef, ParameterRef, Type, AttributeValue._arg_type ]
    c_WriteCallpathParameter.restype = ErrorCode
    c_WriteCallpathParameter.errcheck = HandleErrorCode
    c_WriteCallpathParameter(writerHandle, callpath, parameter, type, value._arg_value)

def GlobalDefWriter_WriteInterComm(writerHandle, self, name, groupA, groupB, commonCommunicator, flags):
    c_WriteInterComm = conf.lib.OTF2_GlobalDefWriter_WriteInterComm
    c_WriteInterComm.argtypes = [ ctypes.POINTER(GlobalDefWriter), CommRef, StringRef, GroupRef, GroupRef, CommRef, CommFlag ]
    c_WriteInterComm.restype = ErrorCode
    c_WriteInterComm.errcheck = HandleErrorCode
    c_WriteInterComm(writerHandle, self, name, groupA, groupB, commonCommunicator, flags)

__all__ = [
    'GlobalDefWriter',
    'GlobalDefWriter_GetNumberOfDefinitions',
    'GlobalDefWriter_GetNumberOfLocations',
    'GlobalDefWriter_WriteClockProperties',
    'GlobalDefWriter_WriteParadigm',
    'GlobalDefWriter_WriteParadigmProperty',
    'GlobalDefWriter_WriteIoParadigm',
    'GlobalDefWriter_WriteString',
    'GlobalDefWriter_WriteAttribute',
    'GlobalDefWriter_WriteSystemTreeNode',
    'GlobalDefWriter_WriteLocationGroup',
    'GlobalDefWriter_WriteLocation',
    'GlobalDefWriter_WriteRegion',
    'GlobalDefWriter_WriteCallsite',
    'GlobalDefWriter_WriteCallpath',
    'GlobalDefWriter_WriteGroup',
    'GlobalDefWriter_WriteMetricMember',
    'GlobalDefWriter_WriteMetricClass',
    'GlobalDefWriter_WriteMetricInstance',
    'GlobalDefWriter_WriteComm',
    'GlobalDefWriter_WriteParameter',
    'GlobalDefWriter_WriteRmaWin',
    'GlobalDefWriter_WriteMetricClassRecorder',
    'GlobalDefWriter_WriteSystemTreeNodeProperty',
    'GlobalDefWriter_WriteSystemTreeNodeDomain',
    'GlobalDefWriter_WriteLocationGroupProperty',
    'GlobalDefWriter_WriteLocationProperty',
    'GlobalDefWriter_WriteCartDimension',
    'GlobalDefWriter_WriteCartTopology',
    'GlobalDefWriter_WriteCartCoordinate',
    'GlobalDefWriter_WriteSourceCodeLocation',
    'GlobalDefWriter_WriteCallingContext',
    'GlobalDefWriter_WriteCallingContextProperty',
    'GlobalDefWriter_WriteInterruptGenerator',
    'GlobalDefWriter_WriteIoFileProperty',
    'GlobalDefWriter_WriteIoRegularFile',
    'GlobalDefWriter_WriteIoDirectory',
    'GlobalDefWriter_WriteIoHandle',
    'GlobalDefWriter_WriteIoPreCreatedHandleState',
    'GlobalDefWriter_WriteCallpathParameter',
    'GlobalDefWriter_WriteInterComm',
]
