
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeList import AttributeList
from .Definitions import *
from .Events import *


class SnapWriter(ctypes.Structure):
    pass

def SnapWriter_GetLocationID(writer, locationID = LocationRef()):
    c_GetLocationID = conf.lib.OTF2_SnapWriter_GetLocationID
    c_GetLocationID.argtypes = [ ctypes.POINTER(SnapWriter), ctypes.POINTER(LocationRef) ]
    c_GetLocationID.restype = ErrorCode
    c_GetLocationID.errcheck = HandleErrorCode
    c_GetLocationID(writer, ctypes.byref(locationID))
    return locationID.value

@otf2 for snap in snaps:
@otf2  if snap == MetricSnap:
def SnapWriter_Metric(writerHandle, attributeList, snapTime, origEventTime, metric, typeIDs, metricValues):
    numberOfMetrics = len(metricValues)
    assert(numberOfMetrics == len(typeIDs))

    TypeArrayType = Type * numberOfMetrics
    type_ids_list = TypeArrayType()
    type_ids_list[:] = typeIDs

    MetricValueArrayType = MetricValue * numberOfMetrics
    metric_values_list = MetricValueArrayType()
    metric_values_list[:] = metricValues

    c_Metric = conf.lib.OTF2_SnapWriter_Metric
    c_Metric.argtypes = [ ctypes.POINTER(SnapWriter), ctypes.POINTER(AttributeList), TimeStamp , TimeStamp, MetricRef, ctypes.c_uint8, TypeArrayType, MetricValueArrayType ]
    c_Metric.restype = ErrorCode
    c_Metric.errcheck = HandleErrorCode
    c_Metric(writerHandle, attributeList, snapTime , origEventTime, metric, numberOfMetrics, type_ids_list, metric_values_list)

@otf2  else:
def SnapWriter_@@snap.name@@(writerHandle, attributeList, snapTime@@snap.py_funcargs()@@):
    c_@@snap.name@@ = conf.lib.OTF2_SnapWriter_@@snap.name@@
    c_@@snap.name@@.argtypes = [ ctypes.POINTER(SnapWriter), ctypes.POINTER(AttributeList), TimeStamp@@snap.py_funcargtypes(argtypes=False)@@ ]
    c_@@snap.name@@.restype = ErrorCode
    c_@@snap.name@@.errcheck = HandleErrorCode
    c_@@snap.name@@(writerHandle, attributeList, snapTime@@snap.py_callargs(pass_by_ref=True)@@)

@otf2  endif
@otf2 endfor
__all__ = [
    'SnapWriter',
    'SnapWriter_GetLocationID',
    @otf2 for snap in snaps:
    'SnapWriter_@@snap.name@@',
    @otf2 endfor
]
