/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef TEXTBROWSER_H
#define TEXTBROWSER_H

#include <QTextBrowser>
#include <QHideEvent>
#include <QShowEvent>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class TextBrowser : public QTextBrowser
{
  Q_OBJECT
  public:
    TextBrowser(QWidget *parent = 0);
    ~TextBrowser();

  protected:
    bool viewportEvent(QEvent* ev){emit viewportChanged(); return QTextBrowser::viewportEvent(ev);}
    void hideEvent(QHideEvent* /*ev*/){emit viewportVisible(false);}
    void showEvent(QShowEvent* /*ev*/){emit viewportVisible(true);}

  signals:
    void viewportChanged();
    void viewportVisible(bool);
};

#endif
