/*
	Copyright 2006-2023 The QElectroTech Team
	This file is part of QElectroTech.
	
	QElectroTech is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.
	
	QElectroTech is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with QElectroTech.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef REPORTPROPERTIEWIDGET_H
#define REPORTPROPERTIEWIDGET_H

#include <QWidget>
#include <QSettings>


namespace Ui {
	class ReportPropertieWidget;
}

class ReportPropertieWidget : public QWidget
{
	Q_OBJECT

	public:
	explicit ReportPropertieWidget(const QString& value, QWidget *parent = nullptr);
	~ReportPropertieWidget() override;
	void toSettings (QSettings &settings, const QString &prefix);
	void setReportProperties (const QString& label);
	QString ReportProperties () const;

	private:
	Ui::ReportPropertieWidget *ui;
};

#endif // REPORTPROPERTIEWIDGET_H
