/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "JobCommand.h"



//___________________________________________________________________
unsigned int& JobCommand::_counter( void )
{
    static unsigned int counter( 0 );
    return counter;
}

//___________________________________________________________________
QString JobCommand::name( const Type& type )
{
    Debug::Throw( "JobCommand::name.\n" );

    if( _names().empty() ) _initializeNames();
    NameMap::const_iterator iter( _names().find( type ) );
    return iter != _names().end() ? iter.value():"";
}

//___________________________________________________________________
void JobCommand::_initializeNames( void )
{
    Debug::Throw( "JobCommand::_initializeNames.\n" );

    _names()[None] = QObject::tr( "None" );
    _names()[JobList]= QObject::tr( "Query process list" );
    _names()[Signal]= QObject::tr( "Signal selected processes" );
}

//___________________________________________________________________
JobCommand::NameMap& JobCommand::_names( void )
{
    static NameMap names;
    return names;
}
