/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakecameraflashcontrol.h"
#include "fakecameraservice.h"
#include "fakevideodeviceselectorcontrol.h"

FakeCameraFlashControl::FakeCameraFlashControl(FakeCameraService *service, QObject *parent)
    : QCameraFlashControl(parent),
      m_service(service),
      m_mode(QCameraExposure::FlashAuto)
{
}

QCameraExposure::FlashModes FakeCameraFlashControl::flashMode() const
{
    return m_mode;
}

bool FakeCameraFlashControl::isFlashModeSupported(QCameraExposure::FlashModes mode) const
{
    if (m_service->deviceSelector()->selectedDevice() == 0) {
        return (mode == QCameraExposure::FlashAuto ||
                mode == QCameraExposure::FlashOff ||
                mode == QCameraExposure::FlashOn ||
                mode == QCameraExposure::FlashVideoLight);
    } else {
        return mode == QCameraExposure::FlashOff;
    }
}

bool FakeCameraFlashControl::isFlashReady() const
{
    if (m_service->deviceSelector()->selectedDevice() == 0)
        return true;
    else
        return false;
}

void FakeCameraFlashControl::setFlashMode(QCameraExposure::FlashModes mode)
{
    if (isFlashModeSupported(mode)) {
        m_mode = mode;
    }
}
