% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readIntervalFile.R
\name{readIntervalFile}
\alias{readIntervalFile}
\title{Read interval file}
\usage{
readIntervalFile(interval.file, strict = TRUE, verbose = TRUE)
}
\arguments{
\item{interval.file}{A mapping file that assigns GC content and gene symbols
to each exon in the coverage files. Used for generating gene-level calls.
First column in format CHR:START-END. Second column GC content (0 to 1).
Third column gene symbol. This file is generated with the
\code{\link{preprocessIntervals}} function.}

\item{strict}{Error out with missing columns}

\item{verbose}{Verbose output}
}
\value{
A \code{GRanges} object with the parsed intervals.
}
\description{
Read file containing coordinates of on- and off-target intervals
generated by \code{\link{preprocessIntervals}}.
}
\examples{

interval.file <- system.file("extdata", "example_intervals.txt", 
    package = "PureCN")
x <- readIntervalFile(interval.file)

}
\author{
Markus Riester
}
