%                               -*- Mode: Rd -*- 
% drawnetwork.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:44 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Dec 04 13:15:16 2008
% Update Count    : 50
% Status          : Unknown, Use with caution!
% 

\name{drawnetwork}
\alias{drawnetwork}


%- Also NEED an `\alias' for EACH other topic documented here.

\title{Graphical interface for editing networks}

\description{\code{drawnetwork} allows the user to specify a Bayesian network through a point and click interface.
}

\encoding{latin1}

\usage{
drawnetwork(nw,df,prior,trylist=vector("list",size(nw)),
            unitscale=20,cexscale=8,
            arrowlength=.25,nocalc=FALSE,
            yr=c(0,350),xr=yr,...)


}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}} to be edited.}
  \item{df}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{cexscale}{a numeric passed to the plot method for network
    objects. Measures the scaled size of text and symbols.} 
  \item{arrowlength}{a numeric passed to
     the plot method for network
    objects. Measures the length of the edges of the arrowheads.}
  \item{nocalc}{a logical. If \code{TRUE}, no learning procedure is called, see eg. \code{\link{rnetwork}}.}
  \item{unitscale}{a numeric passed to
     the plot method for network
    objects. Scale parameter for chopping off arrow heads.}
  \item{xr}{a numeric vector with two components containing the range on x-axis.}
  \item{yr}{a numeric vector with two components containing the range on y-axis.}
  \item{...}{additional plot arguments, passed to  the plot method for network
    objects.}
}

\details{
To insert an arrow from node 'A' to node 'B', first click node 'A' and
then click node 'B'. When the graph is finished, click 'stop'.

To specify that an arrow must not be present, press 'ban' (a toggle)
and draw the arrow. This is shown as a red dashed arrow. It is possible
to ban both directions between nodes. The ban list is stored with the
network in the property \code{banlist}. It is a matrix with two
columns. Each row is the 'from' node index and the 'to' node index,
where the indices are the column number in the data frame.

Note that the network score changes as the network is re-learned
whenever a change is made (unless \code{nocalc} is \code{TRUE}).

}

\value{A list with two elements that may be accessed using
  \code{\link{getnetwork}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}} with the final network.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\seealso{\code{\link{network}}
  }

% \references{
%   Further information about \bold{deal} can be found at:\cr
%   \url{http://www.math.aau.dk/~dethlef/novo/deal}.
% }

\author{
  Susanne Gammelgaard Bottcher, \cr
  Claus Dethlefsen \email{rpackage.deal@gmail.com}.
}


\examples{
data(rats)
rats.nw    <- network(rats)
rats.prior <- jointprior(rats.nw,12)
rats.nw    <- getnetwork(learn(rats.nw,rats,rats.prior))

\dontrun{newrat  <- getnetwork(drawnetwork(rats.nw,rats,rats.prior))}
}

\keyword{models}
