% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt.R
\name{encrypt}
\alias{encrypt}
\alias{signature}
\title{Encrypt or sign a message}
\usage{
encrypt(msg, encrypt = TRUE, sign = TRUE, public_key = TRUE)

signature(msg, public_key = TRUE)
}
\arguments{
\item{msg}{A message object.}

\item{encrypt}{Whether to encrypt the message. If \code{TRUE} then the entire
message will be encrypted using the private key of the sender.}

\item{sign}{Whether to sign the message. If \code{TRUE} then the entire
message will be signed using the private key of the sender.}

\item{public_key}{Whether to attach a public key. If \code{TRUE} then the
public key of the sender will be attached.}
}
\value{
A message object.
}
\description{
Specify whether the message should be encrypted, signed or have a public key
attached.
}
\details{
The \code{signature()} function will add a digital signature to a message. It will
also optionally include a copy of the sender's public key.

The \code{encrypt()} function will encrypt the contents of a message using the
public key(s) of the recipient(s). It can also add a digital signature to the
message (this is the default behaviour) and include a copy of the sender's
public key. Signing happens \emph{before} encryption, so the digital signature
will only be accessible once the message has been decrypted. If a recipient
no longer has access to their private key or their email client is unable to
decrypt the message then they will not be able to access the message
contents.
}
\examples{
\dontrun{
msg <- envelope(
  from = "flotilla@kriegsmarine.gov",
  to = "schunk@u-boat.com",
  subject = "Top Secret Message",
  text = "Immediate readiness. There are indications that the invasion has begun."
)
# Encrypt and sign the message.
msg \%>\% encrypt()
# Only encrypt the message.
msg \%>\% encrypt(sign = FALSE)
# Only sign the message.
msg \%>\% signature()
msg \%>\% encrypt(encrypt = FALSE)
}
}
