% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field.R
\name{rd_section}
\alias{rd_section}
\title{Construct an \code{rd_section} object}
\usage{
rd_section(type, value)
}
\arguments{
\item{type}{Section type. Stored in \code{type} field, and in class
\verb{rd_section_\{type\}}. To avoid namespace clashes between different
extensions, this should include the package name.}

\item{value}{Section data. Only used by \code{format()} and \code{merge()} methods.}
}
\description{
An \code{rd_section} represents an Rd command that can appear at the top-level
of an Rd document, like \verb{\\name\{\}}, \verb{\\title\{\}}, \verb{\\description\{\}}, or
\verb{\\section\{\}}.
}
\section{Methods}{

If provide your own \code{rd_section} type, you'll also need to define a
\verb{format.rd_section_\{type\}} method that returns formatted Rd output. You
may also need to provide a \verb{merge.rd_section_\{type\}} method if two
sections can not be combined with \code{rd_section(x$type, c(x$value, y$value))}.
See \code{vignette("extending")} for more details.
}

\keyword{internal}
