% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-adapt_delta.R
\name{adapt_delta}
\alias{adapt_delta}
\title{\code{adapt_delta}: Target average acceptance probability}
\description{
Details about the \code{adapt_delta} argument to \pkg{rstanarm}'s modeling
functions.
}
\details{
For the No-U-Turn Sampler (NUTS), the variant of Hamiltonian Monte
  Carlo used used by \pkg{rstanarm}, \code{adapt_delta} is the target average
  proposal acceptance probability during Stan's adaptation period.
  \code{adapt_delta} is ignored by \pkg{rstanarm} if the \code{algorithm} argument 
  is not set to \code{"sampling"}.
  
  The default value of \code{adapt_delta} is 0.95, except when the prior for 
  the regression coefficients is \code{\link{R2}}, \code{\link{hs}}, or 
  \code{\link{hs_plus}}, in which case the default is 0.99.
  
  These defaults are higher (more conservative) than the default of
  \code{adapt_delta=0.8} used in the \pkg{rstan} package, which may result in
  slower sampling speeds but will be more robust to posterior distributions
  with high curvature.
  
  In general you should not need to change \code{adapt_delta} unless you see
  a warning message about divergent transitions, in which case you can
  increase \code{adapt_delta} from the default to a value \emph{closer} to 1
  (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc). The step size used by
  the numerical integrator is a function of \code{adapt_delta} in that
  increasing \code{adapt_delta} will result in a smaller step size and fewer
  divergences. Increasing \code{adapt_delta} will typically result in a
  slower sampler, but it will always lead to a more robust sampler.
}
\references{
Stan Development Team. \emph{Stan Modeling Language Users Guide and
Reference Manual.} \url{https://mc-stan.org/users/documentation/}.

Brief Guide to Stan's Warnings:
  \url{https://mc-stan.org/misc/warnings.html#divergent-transitions-after-warmup}
}
