% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_overlay.R
\name{config_overlay}
\alias{config_overlay}
\title{Get Solr configuration overlay}
\usage{
config_overlay(conn, name, omitHeader = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core. If not given, all cores.}

\item{omitHeader}{(logical) If \code{TRUE}, omit header. Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list with response from server
}
\description{
Get Solr configuration overlay
}
\examples{
\dontrun{
# start Solr with Cloud mode via the schemaless eg: bin/solr -e cloud
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
(conn <- SolrClient$new())

# get config overlay
conn$config_overlay("gettingstarted")

# without header
conn$config_overlay("gettingstarted", omitHeader = TRUE)
}
}
