\name{saveOptions}
\alias{saveOptions}

\title{
Save R Commander Options in an R Profile File
}

\description{
This dialog creates a \file{.Rprofile} file, by default in the current directory, adding to it the current
R Commander options, set, e.g., in the Options dialog. If R is subsequently restarted in this directory, 
and the \pkg{Rcmdr} package loaded,
then the current R Commander options will be applied. The current directory will typically, though
not necessarily, be your home directory --- for example, for Windows users, your Documents
directory.

If a \file{.Rprofile} file already exists
in the current directory, then the R Commander options are added to it at the end of the file,
after removing R Commander options previously generated by an earlier invocation of this dialog.

The contents of the \file{.Rprofile} file may be edited before you save the file.
If you want to start the R Commander automatically when R starts, uncomment (remove the \code{#}s from)
the four lines

\preformatted{
    # local({
    #    old <- getOption('defaultPackages')
    #    options(defaultPackages = c(old, 'Rcmdr'))
    # })
}

See \code{\link{Startup}} for a description of the \file{.Rprofile}
file and the R startup process in general.

See \code{\link{Commander}} for a description of the various R Commander options.
}

\usage{
saveOptions() # typically through the R Commander Tools menu
}

\author{
John Fox \email{jfox@mcmaster.ca}
}

\seealso{
\code{\link{Commander}}, \code{\link{Startup}}
}

\keyword{misc}
