package RestfulDB::Defaults;

require Exporter;
our @ISA = qw( Exporter );
@EXPORT_OK = qw(
    get_css_styles
    get_default_cgi_parameters
    default_id_column
    history_table_suffix
);

our $website_title = 'SOLSA Databases';
our @keywords = qw( RestfulDB SQL );

our $default_id_column = 'id';

# FIXME: read from the 'restful' database table 'description'.
our $revision_table = 'revision';

our $history_table_suffix = '_history';

our $database_user = 'reader';
our $database_password = '';
our $database_hostname = 'localhost';

our %CGI_parameters = (
    debug     => { re => 'save|false' },
    rows      => { re => '[0-9]+',         default => 100 },
    offset    => { re => '[0-9]+',         default => 0   },

    # Database ordering, e.g.: 'order=revision:u,date:d'. Specifies a
    # comman-separated list of database columns, together with a ':'
    # delimited order specifiers ('a' == ascending, asc; 'd' ==
    # descending, desc)":
    order     => { re => '(?:[A-Za-z0-9_\.]+(?::[ad])?)(?:,[A-Za-z0-9_\.]+(?::[ad])?)*' },

    id_column => { re => '[\w\d_]+', default => $default_id_column },
    engine    => { re => '\w+' },
    db        => { re => '[\w\.]+',
                   errmsg => 'Only file name characters (alphanumerics, ' .
                             'underscore and period) are allowed in ' .
                             'database names, but database \'%s\' was requested' },
    table     => { re => '\w+',
                   errmsg => 'Only indetifier characters (alphanumerics ' .
                             'and underscore) are allowed in table names, ' .
                             'but table \'%s\' was requested' },
);

sub get_default_cgi_parameters { wantarray ? %CGI_parameters : \%CGI_parameters }

sub get_css_styles
{
    my( $db_name, $url_level ) = @_;
    my $css_path;

    if ( !$url_level ) {
        $url_level = 1;
    }
    # 2019.07.15 patch: when the page level is 'zero', set $url_level to -1 and
    # create relative paths that start on the same level as the page.
    if ( $url_level == -1 ) {
        $css_path = "./styles";
    } else {
        $css_path = join '/', ( ('..') x $url_level, 'styles' );
    }

    # STYLE TAGS.
    # Adding styles: via 'default's. 'custom' styles doesn't seem to work.
    my @css_styles = (
                       { -src => "$css_path/default/mini-default.css" },

                       # Initial styles.
                       { -src => "$css_path/default/style.css" },

                       { -src => "$css_path/default/select2.css" } );
    # end STYLE TAGS.
    my $db_name_escaped = $db_name;
    $db_name_escaped =~ s/[^a-zA-Z0-9_\.\-\+]/_/g;
    if( -e "../styles/custom/$db_name_escaped.css" ) {
        push @css_styles,
             { -src => "$css_path/custom/$db_name_escaped.css" };
    }
    return \@css_styles;
}

1;
