#
# R 3d object : o3d
#

oh3d.vb <- c(   
    -1.5, -1.5, -0.5, 1.0,   # 1
    -0.5, -1.5, -0.5, 1.0,   # 2
     0.5, -1.5, -0.5, 1.0,   # 3
     1.5, -1.5, -0.5, 1.0,   # 4

    -1.5, -0.5, -0.5, 1.0,   # 5
    -0.5, -0.5, -0.5, 1.0,   # 6
     0.5, -0.5, -0.5, 1.0,   # 7
     1.5, -0.5, -0.5, 1.0,   # 8

    -1.5,  0.5, -0.5, 1.0,   # 9
    -0.5,  0.5, -0.5, 1.0,   # 10
     0.5,  0.5, -0.5, 1.0,   # 11
     1.5,  0.5, -0.5, 1.0,   # 12
     
    -1.5,  1.5, -0.5, 1.0,   # 13 
    -0.5,  1.5, -0.5, 1.0,   # 14
     0.5,  1.5, -0.5, 1.0,   # 15
     1.5,  1.5, -0.5, 1.0,   # 16

     
    -1.5, -1.5,  0.5, 1.0,   # 17
    -0.5, -1.5,  0.5, 1.0,   # 18
     0.5, -1.5,  0.5, 1.0,   # 19
     1.5, -1.5,  0.5, 1.0,   # 20

    -1.5, -0.5,  0.5, 1.0,   # 21
    -0.5, -0.5,  0.5, 1.0,   # 22
     0.5, -0.5,  0.5, 1.0,   # 23 
     1.5, -0.5,  0.5, 1.0,   # 24

    -1.5,  0.5,  0.5, 1.0,   # 25
    -0.5,  0.5,  0.5, 1.0,   # 26
     0.5,  0.5,  0.5, 1.0,   # 27
     1.5,  0.5,  0.5, 1.0,   # 28
     
    -1.5,  1.5,  0.5, 1.0,   # 29
    -0.5,  1.5,  0.5, 1.0,   # 30
     0.5,  1.5,  0.5, 1.0,   # 31
     1.5,  1.5,  0.5, 1.0    # 32         
)

oh3d.ib <- c(
    1,  5,  6,  2,    
    2,  6,  7,  3,    
    3,  7,  8,  4,
    
    5,  9, 10,  6,    
    7, 11, 12,  8,
    
    9, 13, 14, 10,
   10, 14, 15, 11,
   11, 15, 16, 12,
   
   17, 18, 22, 21,
   18, 19, 23, 22,
   19, 20, 24, 23,
   
   21, 22, 26, 25,
   23, 24, 28, 27,
   
   25, 26, 30, 29,
   26, 27, 31, 30,
   27, 28, 32, 31,
   
    1,  2, 18, 17,
    2,  3, 19, 18,
    3,  4, 20, 19,
    
    6, 22, 23,  7,
   10, 11, 27, 26,
   
   13, 29, 30, 14,
   14, 30, 31, 15,
   15, 31, 32, 16,
   
   17, 21,  5,  1,
   21, 25,  9,  5,
   25, 29, 13,  9,
   
    4,  8, 24, 20,
    8, 12, 28, 24,
   12, 16, 32, 28,
   
    6, 10, 26, 22,
    7, 23, 27, 11  
)

oh3d <- function( trans = identityMatrix(), ... ) {
  return(rotate3d(qmesh3d( oh3d.vb, oh3d.ib, material=list(...) ), matrix=trans))
}

