/*
*  Rubrica
*  file: form.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_FORM_NOTES_H
#define _RUBRICA_FORM_NOTES_H

#include <glib.h>
#include <glib-object.h>
#include <glade/glade.h>

#include "app.h"
#include "form.h"


#define RUBRICA_FORM_NOTES_TYPE           (rubrica_form_notes_get_type())

#define RUBRICA_FORM_NOTES(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                           RUBRICA_FORM_NOTES_TYPE,          \
                                           RubricaFormNotes))

#define RUBRICA_FORM_NOTES_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                           RUBRICA_FORM_NOTES_TYPE,          \
                                           RubricaFormNotesClass))

#define IS_RUBRICA_FORM_NOTES(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                           RUBRICA_FORM_NOTES_TYPE))

#define IS_RUBRICA_FORM_NOTES_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),    \
                                           RUBRICA_FORM_NOTES_TYPE))

#define RUBRICA_FORM_NOTES_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),  \
			                   RUBRICA_FORM_NOTES_TYPE,          \
                                           RubricaFormNotesClass))



typedef struct _RubricaFormNotes        RubricaFormNotes; 
typedef struct _RubricaFormNotesClass   RubricaFormNotesClass;
typedef struct _RubricaFormNotesPrivate RubricaFormNotesPrivate;



struct _RubricaFormNotes {
  RubricaForm parent;
   
  RubricaFormNotesPrivate* priv;  
};



struct _RubricaFormNotesClass {
   RubricaFormClass parent;
};


GType            rubrica_form_notes_get_type (void);


RubricaFormNotes* rubrica_form_notes_new      (RubricaApp* app, GladeXML *gui);
void              rubrica_form_notes_free     (RubricaFormNotes* form);

#endif
