#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the features/changes added for release 1.58:

   - Better parsing of broken MIME headers.
   - The feat_force_name exemption for text/html parts.
   - The format=flowed Eudora fix.
   - The QuotedPrintable encoding/decoding cache.
   - Detecting stuff even after the multipart/* end-of-data marker

tac

# Test data:    
export PERL5LIB="$PERL5LIB:$ANOMY/bin"
QPDATA=$(cat sanitizer.rev1_58.t \
  |perl -MMIME::QuotedPrint -Mbytes -npe '$_=encode_qp($_);s/-/=2D/g')

$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'file_list_rules = 1' \
    'file_list_1_scanner = 0' \
    'file_list_1_policy = drop' \
    'file_list_1 = .exe$' \
    'file_default_policy = accept' \
    'file_default_filename = unknown.000' \
    'file_name_tpl = ./.tmp.$$$' \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_force_name = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: Testing version 1.58
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/html; charset="iso-8859-1"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

<html>This file has no name, but is HTML.</html>

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
Content-Type: application/octet-stream;
charset="evil"
Content-Disposition: attachment; filename="evil.exe"
Content-Transfer-Encoding: 8bit

this is a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--

This should get appended as postamble

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"; format=flowed
Content-Disposition: attachment
Content-Transfer-Encoding: quoted-printable

This file has no name, but is text.
Here's my QP test.  =20
$QPDATA

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/foobar; charset="iso-8859-1"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

This file has no name, but is binary.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF

echo "*** Exit code was $? ***" >>test.out
exit 0
