// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "tcl.h"

#include "colorbarpseudocolor8.h"
#include "util.h"

// Tk Canvas Widget Function Declarations

int ColorbarPseudoColor8CreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int,
				   Tcl_Obj *const []);

// Colorbar Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec colorbarPseudoColor8Specs[] = {

  {TK_CONFIG_STRING, (char*)"-command", NULL, NULL, "colorbar",
   Tk_Offset(ColorbarBaseOptions, cmdName), 
   TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, (char*)"-x", NULL, NULL, "1",
   Tk_Offset(ColorbarBaseOptions, x), TK_CONFIG_OPTION_SPECIFIED, 
   NULL},
  {TK_CONFIG_INT, (char*)"-y", NULL, NULL, "1",
   Tk_Offset(ColorbarBaseOptions, y), TK_CONFIG_OPTION_SPECIFIED, 
   NULL},
  {TK_CONFIG_INT, (char*)"-width", NULL, NULL, "512",
   Tk_Offset(ColorbarBaseOptions, width), TK_CONFIG_OPTION_SPECIFIED, 
   NULL},
  {TK_CONFIG_INT, (char*)"-height", NULL, NULL, "22",
   Tk_Offset(ColorbarBaseOptions, height), TK_CONFIG_OPTION_SPECIFIED,
   NULL},
  {TK_CONFIG_ANCHOR, (char*)"-anchor", NULL, NULL, "nw",
   Tk_Offset(ColorbarBaseOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, (char*)"-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_STRING, (char*)"-helvetica", NULL, NULL, "helvetica",
   Tk_Offset(ColorbarBaseOptions, helvetica), 0, NULL},
  {TK_CONFIG_STRING, (char*)"-courier", NULL, NULL, "courier",
   Tk_Offset(ColorbarBaseOptions, courier), 0, NULL},
  {TK_CONFIG_STRING, (char*)"-times", NULL, NULL, "times",
   Tk_Offset(ColorbarBaseOptions, times), 0, NULL},

  {TK_CONFIG_BOOLEAN, (char*)"-orientation", NULL, NULL, "0",
   Tk_Offset(ColorbarBaseOptions, orientation), 0, NULL},
  {TK_CONFIG_INT, (char*)"-size", NULL, NULL, "20",
   Tk_Offset(ColorbarBaseOptions, size), 0, NULL},

  {TK_CONFIG_STRING, (char*)"-font", NULL, NULL, "helvetica",
   Tk_Offset(ColorbarBaseOptions, font), 0, NULL},
  {TK_CONFIG_INT, (char*)"-fontsize", NULL, NULL, "10",
   Tk_Offset(ColorbarBaseOptions, fontSize), 0, NULL},
  {TK_CONFIG_STRING, (char*)"-fontweight", "fontweight", NULL, "normal",
   Tk_Offset(ColorbarBaseOptions, fontWeight), 0, NULL},
  {TK_CONFIG_SYNONYM, (char*)"-fontstyle", "fontweight", NULL, NULL, 0, 0},
  {TK_CONFIG_STRING, (char*)"-fontslant", NULL, NULL, "roman",
   Tk_Offset(ColorbarBaseOptions, fontSlant), 0, NULL},

  {TK_CONFIG_BOOLEAN, (char*)"-numerics", NULL, NULL, "1",
   Tk_Offset(ColorbarBaseOptions, numerics), 0, NULL},
  {TK_CONFIG_BOOLEAN, (char*)"-space", NULL, NULL, "1",
   Tk_Offset(ColorbarBaseOptions, space), 0, NULL},
  {TK_CONFIG_INT, (char*)"-ticks", NULL, NULL, "11",
   Tk_Offset(ColorbarBaseOptions, ticks), 0, NULL},

  {TK_CONFIG_INT, (char*)"-min", NULL, NULL, "80",
   Tk_Offset(ColorbarBaseOptions, minColors), 0, NULL},
  {TK_CONFIG_INT, (char*)"-max", NULL, NULL, "200",
   Tk_Offset(ColorbarBaseOptions, maxColors), 0, NULL},
  {TK_CONFIG_BOOLEAN, (char*)"-private", NULL, NULL, "false",
   Tk_Offset(ColorbarBaseOptions, privateCmap), 0, NULL},
  {TK_CONFIG_INT, (char*)"-privatecolors", NULL, NULL, "128",
   Tk_Offset(ColorbarBaseOptions, privateColors), 0, NULL},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType colorbarPseudoColor8Type = {
  (char*)"colorbarpseudocolor8",       // name
  sizeof(ColorbarBaseOptions), // size
  ColorbarPseudoColor8CreateProc,  // configProc
  colorbarPseudoColor8Specs,       // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  (Tk_ItemCursorProc*)NULL,     // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int ColorbarPseudoColor8_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&colorbarPseudoColor8Type);
  return TCL_OK;
}

int ColorbarPseudoColor8CreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
				   Tk_Item* item, int argc, 
				   Tcl_Obj *const argv[])
{
  ColorbarPseudoColor8* colorbar = 
    new ColorbarPseudoColor8(interp, canvas, item);

  // and set default configuration
  if (colorbar->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete colorbar;
    Tcl_AppendResult(interp, " error occured while creating colorbar.", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

// ColorbarPseudoColor8

ColorbarPseudoColor8::ColorbarPseudoColor8(Tcl_Interp* i, Tk_Canvas c, 
					   Tk_Item* item) 
  : ColorbarBase(i,c,item), ColorbarPseudoColor(i,c,item)
{
  configSpecs = colorbarPseudoColor8Specs;  // colorbar configure options

  loadDefaultCMaps();
}

// UpdatePixmap. This function is responsable for creating a valid 
// pixmap the size of the current Colorbar

void ColorbarPseudoColor8::ximageToPixmap()
{
  if (!((ColorbarBaseOptions*)options)->orientation) {
    ximageToPixmapHorz();
    XPutImage(display, pixmap, gc, xmap, 0, 0, 1, 1, 
	      options->width-2, ((ColorbarBaseOptions*)options)->size-2);
  }
  else {
    ximageToPixmapVert();
    XPutImage(display, pixmap, gc, xmap, 0, 0, 1, 1, 
	      ((ColorbarBaseOptions*)options)->size-2, options->height-2);
  }
}

void ColorbarPseudoColor8::ximageToPixmapHorz()
{
  int width = options->width-2;
  int height = ((ColorbarBaseOptions*)options)->size-2;
  char* data = XImageData(xmap);

  // Fill in colorbar data
  // --Calculate first row
  for (int ii=0; ii<width; ii++)
    data[ii] = (char)colorIndex[ii*colorCount/width];

  // --and duplicate for remaining rows
  for (int jj=1; jj<height; jj++)
    memcpy(data+(jj*xmap->bytes_per_line), data, xmap->bytes_per_line);
}

void ColorbarPseudoColor8::ximageToPixmapVert()
{
  int width = ((ColorbarBaseOptions*)options)->size-2;
  int height = options->height-2;
  char* data = XImageData(xmap);

  for (int jj=height-1; jj>=0; jj--, data+=xmap->bytes_per_line) {
    char a = (char)colorIndex[jj*colorCount/height];
    for (int ii=0; ii<width; ii++)
      data[ii] = a;
  }
}
