/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisTickPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointFinder;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.ITracePointProvider;
import info.monitorenter.gui.chart.TracePointProviderDefault;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axistickpainters.AxisTickPainterDefault;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart2D
extends JPanel
implements PropertyChangeListener,
Iterable<ITrace2D>,
Printable {
    public static final String[] AXIX_CONSTANT_NAMES = new String[]{"dummy", "X", "Y", "X,Y"};
    public static final int CHART_POSITION_BOTTOM = 32;
    public static final int CHART_POSITION_LEFT = 4;
    public static final int CHART_POSITION_RIGHT = 8;
    public static final int CHART_POSITION_TOP = 16;
    public static final boolean DEBUG_SCALING = false;
    public static final boolean DEBUG_HIGHLIGHTING = false;
    public static final boolean DEBUG_THREADING = false;
    public static final String PROPERTY_ANTIALIASING_ENABLED = "Chart2D.PROPERTY_ANTIALIASING_ENABLED";
    public static final String PROPERTY_AXIS_X = "Chart2D.PROPERTY_AXIS_X";
    public static final String PROPERTY_AXIS_X_BOTTOM_REPLACE = "Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE";
    public static final String PROPERTY_AXIS_X_TOP_REPLACE = "Chart2D.PROPERTY_AXIS_X_TOP_REPLACE";
    public static final String PROPERTY_AXIS_Y = "Chart2D.PROPERTY_AXIS_Y";
    public static final String PROPERTY_AXIS_Y_LEFT_REPLACE = "Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE";
    public static final String PROPERTY_AXIS_Y_RIGHT_REPLACE = "Chart2D.PROPERTY_AXIS_Y_RIGHT_REPLACE";
    public static final String PROPERTY_BACKGROUND_COLOR = "background";
    public static final String PROPERTY_FONT = "font";
    public static final String PROPERTY_FOREGROUND_COLOR = "foreground";
    public static final String PROPERTY_GRID_COLOR = "Chart2D.PROPERTY_GRID_COLOR";
    public static final String PROPERTY_ADD_REMOVE_TRACE = "IAxis.PROPERTY_ADD_REMOVE_TRACE";
    public static final String PROPERTY_PAINTLABELS = "Chart2D.PROPERTY_PAINTLABELS";
    public static final String PROPERTY_POINT_HIGHLIGHTING_ENABLED = "Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED";
    public static final String PROPERTY_POINTFINDER = "Chart2D.POINTFINDER";
    public static final String PROPERTY_TOOLTIP_TYPE = "Chart2D.PROPERTY_TOOLTIP_TYPE";
    public static final int X = 1;
    public static final int X_Y = 3;
    public static final int Y = 2;
    private List<IAxis<?>> m_axesXBottom;
    private List<IAxis<?>> m_axesXTop;
    private List<IAxis<?>> m_axesYLeft;
    private List<IAxis<?>> m_axesYRight;
    private IAxisTickPainter m_axisTickPainter;
    private Color m_gridcolor = Color.lightGray;
    protected int m_minPaintLatency = 50;
    private AAxis<?> m_mouseTranslationXAxis;
    private AAxis<?> m_mouseTranslationYAxis;
    private transient PageFormat m_pageFormat;
    private boolean m_paintLabels = true;
    private IPointFinder m_pointFinder = PointFinder.EUCLID;
    private final PointHighlighter m_pointHighlightListener = new PointHighlighter();
    private Timer m_repainter;
    private boolean m_requestedRepaint;
    private boolean m_synchronizedXStart = false;
    private Chart2D m_synchronizedXStartChart;
    private IToolTipType m_toolTip = ToolTipType.NONE;
    private int m_traceHighlighterCount = 0;
    private ITracePointProvider m_tracePointProvider;
    private boolean m_useAntialiasing = false;
    private int m_xChartEnd;
    private int m_xChartStart;
    private int m_yChartEnd;
    private int m_yChartStart;

    public Chart2D() {
        this.m_axesXBottom = new LinkedList();
        this.m_axesXTop = new LinkedList();
        this.m_axesYLeft = new LinkedList();
        this.m_axesYRight = new LinkedList();
        this.setTracePointProvider(new TracePointProviderDefault());
        AxisLinear axisX = new AxisLinear();
        this.setAxisXBottom(axisX, 0);
        axisX.getAxisTitle().setTitle("X");
        AxisLinear axisY = new AxisLinear();
        this.setAxisYLeft(axisY, 0);
        axisY.getAxisTitle().setTitle("Y");
        this.setAxisTickPainter(new AxisTickPainterDefault());
        Font dflt = this.getFont();
        if (dflt != null) {
            this.setFont(new Font(dflt.getFontName(), dflt.getStyle(), 10));
        }
        this.getBackground();
        this.setBackground(Color.white);
        this.setToolTipType(ToolTipType.NONE);
        this.setRequestedRepaint(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.m_repainter = new Timer(this.m_minPaintLatency, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    if (Chart2D.this.isRequestedRepaint()) {
                        Chart2D.this.repaint(Chart2D.this.m_minPaintLatency);
                        Chart2D.this.setRequestedRepaint(false);
                    }
                }
            }
        });
        Timer.setLogTimers(false);
        this.m_repainter.setRepeats(true);
        this.m_repainter.setCoalesce(true);
        this.m_repainter.start();
    }

    public void addAxisXBottom(AAxis<?> axisX) {
        this.ensureUniqueAxis(axisX);
        this.m_axesXBottom.add(axisX);
        axisX.setChart(this, 1, 32);
        this.listenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, null, axisX);
        this.setRequestedRepaint(true);
    }

    public void addAxisXTop(AAxis<?> axisX) {
        this.ensureUniqueAxis(axisX);
        this.m_axesXTop.add(axisX);
        axisX.setChart(this, 1, 16);
        this.listenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, null, axisX);
        this.setRequestedRepaint(true);
    }

    public void addAxisYLeft(AAxis<?> axisY) {
        this.ensureUniqueAxis(axisY);
        this.m_axesYLeft.add(axisY);
        axisY.setChart(this, 2, 4);
        this.listenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, axisY);
        this.setRequestedRepaint(true);
    }

    public void addAxisYRight(AAxis<?> axisY) {
        this.ensureUniqueAxis(axisY);
        this.m_axesYRight.add(axisY);
        axisY.setChart(this, 2, 8);
        this.listenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, axisY);
        this.setRequestedRepaint(true);
    }

    public final void addTrace(ITrace2D points) {
        IAxis<?> xAxis = this.m_axesXBottom.get(0);
        IAxis<?> yAxis = this.m_axesYLeft.get(0);
        this.addTrace(points, xAxis, yAxis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTrace(ITrace2D points, IAxis<?> xAxis, IAxis<?> yAxis) {
        if (!this.m_axesXBottom.contains(xAxis) && !this.m_axesXTop.contains(xAxis)) {
            throw new IllegalArgumentException("Given x axis (" + xAxis.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisX(AAxis) or addAxisXBottom(AAXis) or addAxisXTop(AAXis)).");
        }
        if (!this.m_axesYLeft.contains(yAxis) && !this.m_axesYRight.contains(yAxis)) {
            throw new IllegalArgumentException("Given y axis (" + yAxis.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisY(AAxis) or addAxisYLeft(AAXis) or addAxisYRight(AAXis)).");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Chart2D chart2D = this;
            synchronized (chart2D) {
                ITrace2D iTrace2D = points;
                synchronized (iTrace2D) {
                    boolean success = false;
                    success |= xAxis.addTrace(points);
                    if (success |= yAxis.addTrace(points)) {
                        this.listenToTrace(points);
                        int amountOfHighlighters = points.getPointHighlighters().size();
                        this.trackHighlightingEnablement(amountOfHighlighters);
                        this.firePropertyChange(PROPERTY_ADD_REMOVE_TRACE, null, points);
                    }
                }
            }
        }
    }

    private int calculateXChartEnd(Graphics g2d) {
        int result = (int)this.getSize().getWidth();
        int axisWidth = 0;
        if (this.m_axesYRight.size() > 0) {
            ListIterator<IAxis<?>> it = this.m_axesYRight.listIterator(this.m_axesYRight.size());
            while (it.hasPrevious()) {
                IAxis<?> currentAxis = it.previous();
                axisWidth = currentAxis.getWidth(g2d);
                currentAxis.setPixelXRight(result);
                if (currentAxis.isVisible()) {
                    result -= axisWidth;
                }
                currentAxis.setPixelXLeft(result);
            }
            if ((double)result == this.getSize().getWidth()) {
                result -= 20;
            }
        } else {
            int tmp;
            Iterator<IAxis<?>> it = this.m_axesXBottom.iterator();
            int xAxesMaxLabelWidth = 0;
            while (it.hasNext()) {
                IAxis<?> currentAxis = it.next();
                tmp = currentAxis.getWidth(g2d);
                if (tmp <= xAxesMaxLabelWidth) continue;
                xAxesMaxLabelWidth = tmp;
            }
            for (IAxis<?> currentAxis : this.m_axesXTop) {
                tmp = currentAxis.getWidth(g2d);
                if (tmp <= xAxesMaxLabelWidth) continue;
                xAxesMaxLabelWidth = tmp;
            }
            result -= xAxesMaxLabelWidth;
        }
        return result;
    }

    private int calculateXChartStart(Graphics g2d) {
        int result = 0;
        ListIterator<IAxis<?>> it = this.m_axesYLeft.listIterator(this.m_axesYLeft.size());
        while (it.hasPrevious()) {
            IAxis<?> currentAxis = it.previous();
            currentAxis.setPixelXLeft(result);
            if (currentAxis.isVisible()) {
                result += currentAxis.getWidth(g2d);
            }
            currentAxis.setPixelXRight(result);
        }
        return result > 0 ? result : 20;
    }

    private int installXAxisLeftOffset(Graphics g2d, int offset) {
        int result = offset;
        ListIterator<IAxis<?>> it = this.m_axesYLeft.listIterator(this.m_axesYLeft.size());
        while (it.hasPrevious()) {
            IAxis<?> currentAxis = it.previous();
            currentAxis.setPixelXLeft(result);
            if (currentAxis.isVisible()) {
                result += currentAxis.getWidth(g2d);
            }
            currentAxis.setPixelXRight(result);
        }
        return result > 0 ? result : 20;
    }

    private int calculateYChartEnd(Graphics g2d) {
        int tmp;
        int result = 0;
        int maxAxisYHeight = 0;
        int axesXTopHeight = 0;
        for (IAxis<?> currentAxis : this.m_axesYLeft) {
            tmp = currentAxis.getHeight(g2d);
            if (!currentAxis.isVisible() || tmp <= maxAxisYHeight) continue;
            maxAxisYHeight = tmp;
        }
        for (IAxis<?> currentAxis : this.m_axesYRight) {
            tmp = currentAxis.getHeight(g2d);
            if (!currentAxis.isVisible() || tmp <= maxAxisYHeight) continue;
            maxAxisYHeight = tmp;
        }
        ListIterator<IAxis<?>> listIt = this.m_axesXTop.listIterator(this.m_axesXTop.size());
        int axisHeight = 0;
        while (listIt.hasPrevious()) {
            IAxis<?> currentAxis;
            currentAxis = listIt.previous();
            currentAxis.setPixelYTop(axesXTopHeight);
            axisHeight = currentAxis.getHeight(g2d);
            if (currentAxis.isVisible()) {
                axesXTopHeight += axisHeight;
            }
            currentAxis.setPixelYBottom(axesXTopHeight);
        }
        result = Math.max(maxAxisYHeight, axesXTopHeight);
        return result > 0 ? result : 20;
    }

    private int calculateYChartStart(Graphics g2d, int labelHeight) {
        int result = (int)this.getSize().getHeight();
        result -= labelHeight;
        int axesXBottomHeight = 0;
        for (IAxis<?> currentAxis : this.m_axesXBottom) {
            currentAxis.setPixelYBottom(result);
            if (currentAxis.isVisible()) {
                result -= currentAxis.getHeight(g2d);
            }
            currentAxis.setPixelYTop(result);
        }
        if ((double)(result -= axesXBottomHeight) == this.getSize().getHeight()) {
            result -= 20;
        }
        return result;
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip result = super.createToolTip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            this.m_axesXBottom.clear();
            this.m_axesXBottom = null;
            this.m_axesXTop.clear();
            this.m_axesXTop = null;
            this.m_axesYLeft.clear();
            this.m_axesYLeft = null;
            this.m_axesYRight.clear();
            this.m_axesYRight = null;
            this.m_repainter.stop();
        }
    }

    public boolean enablePointHighlighting(boolean onoff) {
        boolean result = this.m_pointHighlightListener.setActive(onoff);
        return result;
    }

    private void ensureUniqueAxis(IAxis<?> axisToAdd) {
        if (this.m_axesXBottom.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as bottom x axis!");
        }
        if (this.m_axesXTop.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as top x axis!");
        }
        if (this.m_axesYLeft.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as left y axis!");
        }
        if (this.m_axesYRight.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as right y axis!");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public IAxis<?>[] findAxesOfTrace(ITrace2D trace) {
        IAxis[] result = new IAxis[2];
        IAxis<?> xAxis = null;
        for (IAxis<?> axis : this.m_axesXBottom) {
            if (!axis.getTraces().contains(trace)) continue;
            xAxis = axis;
            break;
        }
        if (xAxis == null) {
            for (IAxis<?> axis : this.m_axesXTop) {
                if (!axis.getTraces().contains(trace)) continue;
                xAxis = axis;
                break;
            }
        }
        IAxis<?> yAxis = null;
        for (IAxis<?> axis : this.m_axesYLeft) {
            if (!axis.getTraces().contains(trace)) continue;
            yAxis = axis;
            break;
        }
        if (yAxis == null) {
            for (IAxis<?> axis : this.m_axesYRight) {
                if (!axis.getTraces().contains(trace)) continue;
                yAxis = axis;
                break;
            }
        }
        result[0] = xAxis;
        result[1] = yAxis;
        return result;
    }

    public final List<IAxis<?>> getAxes() {
        LinkedList result = new LinkedList();
        result.addAll(this.getAxesXBottom());
        result.addAll(this.getAxesXTop());
        result.addAll(this.getAxesYLeft());
        result.addAll(this.getAxesYRight());
        return result;
    }

    public final List<IAxis<?>> getAxesXBottom() {
        return this.m_axesXBottom;
    }

    public final List<IAxis<?>> getAxesXTop() {
        return this.m_axesXTop;
    }

    public final List<IAxis<?>> getAxesYLeft() {
        return this.m_axesYLeft;
    }

    public final List<IAxis<?>> getAxesYRight() {
        return this.m_axesYRight;
    }

    public IAxisTickPainter getAxisTickPainter() {
        return this.m_axisTickPainter;
    }

    public final IAxis<?> getAxisX() {
        return this.m_axesXBottom.get(0);
    }

    public IAxis<?> getAxisX(ITrace2D trace) {
        IAxis<?> result = null;
        IAxis<?> current2 = null;
        for (IAxis<?> current2 : this.m_axesXBottom) {
            if (!current2.hasTrace(trace)) continue;
            result = current2;
            break;
        }
        if (result == null) {
            for (IAxis<?> current2 : this.m_axesXTop) {
                if (!current2.hasTrace(trace)) continue;
                result = current2;
                break;
            }
        }
        return result;
    }

    public final IAxis<?> getAxisY() {
        return this.m_axesYLeft.get(0);
    }

    public IAxis<?> getAxisY(ITrace2D trace) {
        IAxis<?> result = null;
        IAxis<?> current2 = null;
        for (IAxis<?> current2 : this.m_axesYLeft) {
            if (!current2.hasTrace(trace)) continue;
            result = current2;
            break;
        }
        if (result == null) {
            for (IAxis<?> current2 : this.m_axesYRight) {
                if (!current2.hasTrace(trace)) continue;
                result = current2;
                break;
            }
        }
        return result;
    }

    public final Color getGridColor() {
        return this.m_gridcolor;
    }

    @Override
    public int getHeight() {
        Chart2DActionPrintSingleton printTrigger;
        int result = -1;
        if (this.m_pageFormat != null && (printTrigger = Chart2DActionPrintSingleton.getInstance(this)) != null && printTrigger.isPrintWholePage()) {
            int dpiScreen = Toolkit.getDefaultToolkit().getScreenResolution();
            result = (int)this.m_pageFormat.getImageableHeight() * 72 / dpiScreen;
        }
        if (result == -1) {
            result = super.getHeight();
        }
        return result;
    }

    public synchronized int getMinPaintLatency() {
        return this.m_minPaintLatency;
    }

    public ITracePoint2D getNearestPointEuclid(int mouseEventX, int mouseEventY) {
        double rangeY;
        ITracePoint2D result = null;
        double scaledX = 0.0;
        double scaledY = 0.0;
        double rangeX = this.getXChartEnd() - this.getXChartStart();
        if (rangeX != 0.0) {
            scaledX = ((double)mouseEventX - (double)this.getXChartStart()) / rangeX;
        }
        if ((rangeY = (double)(this.getYChartStart() - this.getYChartEnd())) != 0.0) {
            scaledY = 1.0 - ((double)mouseEventY - (double)this.getYChartEnd()) / rangeY;
        }
        SortedSet<ITrace2D> traces = this.getTraces();
        ITrace2D.DistancePoint winner = null;
        for (ITrace2D trace : traces) {
            ITrace2D.DistancePoint distanceBean = trace.getNearestPointEuclid(scaledX, scaledY);
            if (winner == null) {
                winner = distanceBean;
                continue;
            }
            if (!(distanceBean.getDistance() < winner.getDistance())) continue;
            winner = distanceBean;
        }
        if (winner != null) {
            result = winner.getPoint();
        }
        return result;
    }

    public ITracePoint2D getNearestPointEuclid(MouseEvent me) {
        return this.getNearestPointEuclid(me.getX(), me.getY());
    }

    public ITracePoint2D getNearestPointManhattan(int mouseEventX, int mouseEventY) {
        double rangeY;
        ITracePoint2D result = null;
        double scaledX = 0.0;
        double scaledY = 0.0;
        double rangeX = this.getXChartEnd() - this.getXChartStart();
        if (rangeX != 0.0) {
            scaledX = ((double)mouseEventX - (double)this.getXChartStart()) / rangeX;
        }
        if ((rangeY = (double)(this.getYChartStart() - this.getYChartEnd())) != 0.0) {
            scaledY = 1.0 - ((double)mouseEventY - (double)this.getYChartEnd()) / rangeY;
        }
        SortedSet<ITrace2D> traces = this.getTraces();
        ITrace2D.DistancePoint winner = null;
        for (ITrace2D trace : traces) {
            ITrace2D.DistancePoint distanceBean = trace.getNearestPointManhattan(scaledX, scaledY);
            if (winner == null) {
                winner = distanceBean;
                continue;
            }
            if (!(distanceBean.getDistance() < winner.getDistance())) continue;
            winner = distanceBean;
        }
        if (winner != null) {
            result = winner.getPoint();
        }
        return result;
    }

    public ITracePoint2D getNearestPointManhattan(MouseEvent me) {
        return this.getNearestPointManhattan(me.getX(), me.getY());
    }

    public IPointFinder getPointFinder() {
        return this.m_pointFinder;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final synchronized Chart2D getSynchronizedXStartChart() {
        return this.m_synchronizedXStartChart;
    }

    @Override
    public final String getToolTipText(MouseEvent event) {
        String result = this.m_toolTip.getToolTipText(this, event);
        if (result == null) {
            result = super.getToolTipText(event);
        }
        return result;
    }

    public IToolTipType getToolTipType() {
        return this.m_toolTip;
    }

    public ITracePointProvider getTracePointProvider() {
        return this.m_tracePointProvider;
    }

    public final SortedSet<ITrace2D> getTraces() {
        Set<ITrace2D> axisTraces;
        TreeSet<ITrace2D> result = new TreeSet<ITrace2D>();
        for (IAxis<?> currentAxis : this.m_axesXBottom) {
            axisTraces = currentAxis.getTraces();
            for (ITrace2D trace : axisTraces) {
                result.add(trace);
            }
        }
        for (IAxis<?> currentAxis : this.m_axesXTop) {
            axisTraces = currentAxis.getTraces();
            for (ITrace2D trace : axisTraces) {
                result.add(trace);
            }
        }
        return result;
    }

    @Override
    public int getWidth() {
        Chart2DActionPrintSingleton printTrigger;
        int result = -1;
        if (this.m_pageFormat != null && (printTrigger = Chart2DActionPrintSingleton.getInstance(this)) != null && printTrigger.isPrintWholePage()) {
            int dpiScreen = Toolkit.getDefaultToolkit().getScreenResolution();
            result = (int)this.m_pageFormat.getImageableWidth() * 72 / dpiScreen;
        }
        if (result == -1) {
            result = super.getWidth();
        }
        return result;
    }

    public final synchronized int getXAxisWidth() {
        return this.m_xChartEnd - this.m_xChartStart;
    }

    public final synchronized int getXChartEnd() {
        return this.m_xChartEnd;
    }

    public final synchronized int getXChartStart() {
        return this.m_xChartStart;
    }

    public final synchronized int getYChartEnd() {
        return this.m_yChartEnd;
    }

    public synchronized int getYChartStart() {
        return this.m_yChartStart;
    }

    private boolean hasChartIntersection(ITracePoint2D oldpoint, ITracePoint2D newpoint) {
        boolean result = true;
        result = oldpoint.getScaledX() != newpoint.getScaledX() || oldpoint.getScaledY() != newpoint.getScaledY();
        return result;
    }

    private void internalTransferAxisState(IAxis<?> old, AAxis<?> axisNew) {
        Set<ITrace2D> traces = old.removeAllTraces();
        for (ITrace2D trace : traces) {
            axisNew.addTrace(trace);
        }
        IAxis.AxisTitle title = old.removeAxisTitle();
        axisNew.setAxisTitle(title);
        IAxisLabelFormatter formatter = old.getFormatter();
        axisNew.setFormatter(formatter);
        boolean isPaintGrid = old.isPaintGrid();
        axisNew.setPaintGrid(isPaintGrid);
        boolean isPaintScale = old.isPaintScale();
        axisNew.setPaintScale(isPaintScale);
        boolean startMajorTick = old.isStartMajorTick();
        axisNew.setStartMajorTick(startMajorTick);
        boolean visible = old.isVisible();
        axisNew.setVisible(visible);
        IRangePolicy rangePolicy = old.getRangePolicy();
        axisNew.setRangePolicy(rangePolicy);
        Range range = old.getRange();
        axisNew.setRange(range);
    }

    private ITracePoint2D interpolateVisible(ITracePoint2D invisible, ITracePoint2D visible) {
        ITracePoint2D result;
        if (invisible == null) {
            result = visible;
        } else {
            double xInterpolate = Double.NaN;
            double yInterpolate = Double.NaN;
            boolean interpolated = false;
            boolean interpolatedWrong = false;
            if (invisible.getScaledX() > 1.0) {
                xInterpolate = 1.0;
                yInterpolate = (visible.getScaledY() - invisible.getScaledY()) / (visible.getScaledX() - invisible.getScaledX()) * (1.0 - invisible.getScaledX()) + invisible.getScaledY();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(yInterpolate) || yInterpolate < 0.0 || yInterpolate > 1.0;
            }
            if (invisible.getScaledX() < 0.0 && (!interpolated || interpolatedWrong)) {
                xInterpolate = 0.0;
                yInterpolate = (visible.getScaledY() - invisible.getScaledY()) / (visible.getScaledX() - invisible.getScaledX()) * -invisible.getScaledX() + invisible.getScaledY();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(yInterpolate) || yInterpolate < 0.0 || yInterpolate > 1.0;
            }
            if (invisible.getScaledY() > 1.0 && (!interpolated || interpolatedWrong)) {
                yInterpolate = 1.0;
                xInterpolate = (1.0 - invisible.getScaledY()) * (visible.getScaledX() - invisible.getScaledX()) / (visible.getScaledY() - invisible.getScaledY()) + invisible.getScaledX();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(xInterpolate) || xInterpolate < 0.0 || xInterpolate > 1.0;
            }
            if (invisible.getScaledY() < 0.0 && (!interpolated || interpolatedWrong)) {
                yInterpolate = 0.0;
                xInterpolate = -invisible.getScaledY() * (visible.getScaledX() - invisible.getScaledX()) / (visible.getScaledY() - invisible.getScaledY()) + invisible.getScaledX();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(xInterpolate) || xInterpolate < 0.0 || xInterpolate > 1.0;
            }
            if (interpolatedWrong) {
                result = visible;
            } else {
                result = this.m_tracePointProvider.createTracePoint(0.0, 0.0);
                for (IPointPainter<?> highlighter : invisible.getAdditionalPointPainters()) {
                    result.addAdditionalPointPainter(highlighter);
                }
                result.setScaledX(xInterpolate);
                result.setScaledY(yInterpolate);
                result.setListener(invisible.getListener());
            }
        }
        return result;
    }

    public boolean isEnabledPointHighlighting() {
        boolean isEnabled = false;
        for (MouseMotionListener listener : this.getMouseMotionListeners()) {
            if (listener != this.m_pointHighlightListener) continue;
            isEnabled = true;
            break;
        }
        return isEnabled;
    }

    public final boolean isPaintLabels() {
        return this.m_paintLabels;
    }

    protected synchronized boolean isRequestedRepaint() {
        return this.m_requestedRepaint;
    }

    public final boolean isToolTipCoords() {
        return this.m_toolTip == ToolTipType.DATAVALUES;
    }

    public final boolean isUseAntialiasing() {
        return this.m_useAntialiasing;
    }

    public boolean isVisible(ITracePoint2D point) {
        boolean result = point == null ? false : !(Double.isNaN(point.getScaledX()) || Double.isNaN(point.getScaledY()) || point.getScaledX() > 1.0 || point.getScaledX() < 0.0 || point.getScaledY() > 1.0 || point.getScaledY() < 0.0);
        return result;
    }

    @Override
    public final Iterator<ITrace2D> iterator() {
        return this.getTraces().iterator();
    }

    private void listenToAxis(IAxis<?> axis) {
        axis.addPropertyChangeListener(PROPERTY_ADD_REMOVE_TRACE, this);
        axis.addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        axis.addPropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        axis.addPropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
        axis.addPropertyChangeListener("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", this);
    }

    private void listenToTrace(ITrace2D trace) {
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this.m_pointHighlightListener);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void negociateXChart(Graphics g2d) {
        if (this.m_synchronizedXStartChart != null) {
            int myXChartStart = this.calculateXChartStart(g2d);
            int otherXChartStart = this.m_synchronizedXStartChart.calculateXChartStart(g2d);
            int correctionShift = Math.abs(myXChartStart - otherXChartStart);
            this.m_xChartStart = Math.max(this.calculateXChartStart(g2d), this.m_synchronizedXStartChart.calculateXChartStart(g2d));
            this.m_xChartEnd = Math.max(this.calculateXChartEnd(g2d), this.m_synchronizedXStartChart.calculateXChartEnd(g2d));
            Chart2D chart2D = this.m_synchronizedXStartChart;
            synchronized (chart2D) {
                this.m_synchronizedXStartChart.m_xChartStart = this.m_xChartStart;
                this.m_synchronizedXStartChart.m_xChartEnd = this.m_xChartEnd;
                if (myXChartStart > otherXChartStart) {
                    this.m_synchronizedXStartChart.installXAxisLeftOffset(g2d, correctionShift);
                } else {
                    this.installXAxisLeftOffset(g2d, correctionShift);
                }
            }
        } else if (!this.m_synchronizedXStart) {
            this.m_xChartStart = this.calculateXChartStart(g2d);
            this.m_xChartEnd = this.calculateXChartEnd(g2d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.paint(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_pageFormat != null) {
            Graphics2D g2d = (Graphics2D)g;
            double startX = this.m_pageFormat.getImageableX();
            double startY = this.m_pageFormat.getImageableY();
            g2d.translate(startX, startY);
        }
        this.updateScaling(false);
        this.negociateXChart(g);
        int labelHeight = this.paintTraceLabels(g);
        this.m_yChartStart = this.calculateYChartStart(g, labelHeight);
        this.m_yChartEnd = this.calculateYChartEnd(g);
        int rangex = this.m_xChartEnd - this.m_xChartStart;
        int rangey = this.m_yChartStart - this.m_yChartEnd;
        this.paintCoordinateSystem(g);
        int tmpx = 0;
        int tmpy = 0;
        ITracePoint2D oldpoint = null;
        ITracePoint2D newpoint = null;
        ITracePoint2D tmppt = null;
        Iterator traceIt = this.getTraces().iterator();
        Graphics2D g2d = null;
        Stroke backupStroke = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            backupStroke = g2d.getStroke();
            if (this.isUseAntialiasing()) {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        int count = 0;
        while (traceIt.hasNext()) {
            oldpoint = null;
            newpoint = null;
            ++count;
            ITrace2D trace = (ITrace2D)traceIt.next();
            if (!trace.isVisible()) continue;
            ITrace2D iTrace2D = trace;
            synchronized (iTrace2D) {
                boolean hasErrorBars = trace.getHasErrorBars();
                if (g2d != null) {
                    g2d.setStroke(trace.getStroke());
                }
                g.setColor(trace.getColor());
                Set<ITracePainter<?>> tracePainters = trace.getTracePainters();
                Iterator<ITracePainter<?>> itTracePainters = tracePainters.iterator();
                ITracePainter<?> tracePainter2 = null;
                while (itTracePainters.hasNext()) {
                    tracePainter2 = itTracePainters.next();
                    tracePainter2.startPaintIteration(g);
                }
                if (hasErrorBars) {
                    IErrorBarPolicy<?> errorBarPolicy2 = null;
                    Set<IErrorBarPolicy<?>> errorBarPolicies = trace.getErrorBarPolicies();
                    for (IErrorBarPolicy<?> errorBarPolicy2 : errorBarPolicies) {
                        errorBarPolicy2.startPaintIteration(g);
                    }
                }
                Iterator<ITracePoint2D> pointIt = trace.iterator();
                boolean newpointVisible = false;
                boolean oldpointVisible = false;
                while (pointIt.hasNext()) {
                    boolean isNanOldpoint;
                    boolean isNaNNewpoint;
                    oldpoint = newpoint;
                    int oldtmpx = tmpx;
                    int oldtmpy = tmpy;
                    newpoint = pointIt.next();
                    newpointVisible = this.isVisible(newpoint);
                    oldpointVisible = this.isVisible(oldpoint);
                    boolean bl = isNaNNewpoint = Double.isNaN(newpoint.getX()) || Double.isNaN(newpoint.getY());
                    if (oldpoint == null) {
                        isNanOldpoint = false;
                    } else {
                        boolean bl2 = isNanOldpoint = Double.isNaN(oldpoint.getX()) || Double.isNaN(oldpoint.getY());
                    }
                    if (isNaNNewpoint || isNanOldpoint) {
                        if (!isNanOldpoint && isNaNNewpoint) {
                            for (ITracePainter<?> painter : trace.getTracePainters()) {
                                painter.discontinue(g2d);
                            }
                        }
                        if (isNaNNewpoint) continue;
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        continue;
                    }
                    if (!newpointVisible && !oldpointVisible) {
                        tmppt = (ITracePoint2D)newpoint.clone();
                        int tmptmpx = tmpx;
                        int tmptmpy = tmpy;
                        oldpoint = this.interpolateVisible(oldpoint, newpoint);
                        newpoint = this.interpolateVisible(newpoint, oldpoint);
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        oldtmpx = this.m_xChartStart + (int)Math.round(oldpoint.getScaledX() * (double)rangex);
                        oldtmpy = this.m_yChartStart - (int)Math.round(oldpoint.getScaledY() * (double)rangey);
                        if (this.hasChartIntersection(oldpoint, newpoint)) {
                            this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, trace, g, newpoint, false);
                        }
                        newpoint = tmppt;
                        tmpx = tmptmpx;
                        tmpy = tmptmpy;
                        continue;
                    }
                    if (newpointVisible && !oldpointVisible) {
                        oldpoint = this.interpolateVisible(oldpoint, newpoint);
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        oldtmpx = this.m_xChartStart + (int)Math.round(oldpoint.getScaledX() * (double)rangex);
                        oldtmpy = this.m_yChartStart - (int)Math.round(oldpoint.getScaledY() * (double)rangey);
                        this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, trace, g, newpoint, false);
                        continue;
                    }
                    if (!newpointVisible && oldpointVisible) {
                        tmppt = (ITracePoint2D)newpoint.clone();
                        newpoint = this.interpolateVisible(newpoint, oldpoint);
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, trace, g, newpoint, false);
                        newpoint = tmppt;
                        continue;
                    }
                    tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                    tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                    this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, false, trace, g, newpoint, hasErrorBars);
                }
                for (ITracePainter<?> tracePainter2 : trace.getTracePainters()) {
                    tracePainter2.endPaintIteration(g);
                }
                if (hasErrorBars) {
                    for (IErrorBarPolicy<?> errorBarPolicy2 : trace.getErrorBarPolicies()) {
                        errorBarPolicy2.endPaintIteration(g);
                    }
                }
            }
        }
        if (g2d != null) {
            g2d.setStroke(backupStroke);
        }
    }

    private void paintCoordinateSystem(Graphics g2d) {
        g2d.setColor(this.getForeground());
        for (IAxis<?> currentAxis : this.m_axesXBottom) {
            currentAxis.paint(g2d);
        }
        for (IAxis<?> currentAxis : this.m_axesXTop) {
            currentAxis.paint(g2d);
        }
        for (IAxis<?> currentAxis : this.m_axesYLeft) {
            currentAxis.paint(g2d);
        }
        for (IAxis<?> currentAxis : this.m_axesYRight) {
            currentAxis.paint(g2d);
        }
    }

    private void paintErrorBars(ITrace2D trace, int oldtmpx, int oldtmpy, int tmpx, int tmpy, Graphics g2d, boolean discontinue, ITracePoint2D original) {
        for (IErrorBarPolicy<?> errorBarPolicy : trace.getErrorBarPolicies()) {
            errorBarPolicy.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, g2d, original);
            if (!discontinue) continue;
            errorBarPolicy.discontinue(g2d);
        }
    }

    private final void paintPoint(int xPxOld, int yPxOld, int xPxNew, int yPxNew, boolean discontinue, ITrace2D trace, Graphics g2d, ITracePoint2D original, boolean errorBarSupport) {
        for (ITracePainter<?> tracePainter : trace.getTracePainters()) {
            tracePainter.paintPoint(xPxOld, yPxOld, xPxNew, yPxNew, g2d, original);
            Set<IPointPainter<?>> additionalHighlighters = original.getAdditionalPointPainters();
            for (IPointPainter<?> highlighter : additionalHighlighters) {
                highlighter.paintPoint(xPxNew, yPxNew, xPxNew, yPxNew, g2d, original);
            }
            if (!discontinue) continue;
            tracePainter.discontinue(g2d);
        }
        if (errorBarSupport) {
            this.paintErrorBars(trace, xPxOld, yPxOld, xPxNew, yPxNew, g2d, discontinue, original);
        }
    }

    private int paintTraceLabels(Graphics g2d) {
        int labelheight = 0;
        Dimension d = this.getSize();
        if (this.m_paintLabels) {
            int remwidth;
            Iterator traceIt = this.getTraces().iterator();
            int xtmpos = this.m_xChartStart;
            int ytmpos = (int)d.getHeight() - 2;
            int allwidth = remwidth = (int)d.getWidth() - this.m_xChartStart;
            int lblwidth = 0;
            boolean crlfdone = false;
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontheight = fontdim.getHeight();
            if (traceIt.hasNext()) {
                labelheight += fontheight;
            }
            while (traceIt.hasNext()) {
                String tmplabel;
                ITrace2D trace = (ITrace2D)traceIt.next();
                if (!trace.isVisible() || StringUtil.isEmpty(tmplabel = trace.getLabel())) continue;
                lblwidth = fontdim.stringWidth(tmplabel) + 10;
                if (lblwidth > remwidth) {
                    if (lblwidth <= allwidth || !crlfdone) {
                        ytmpos -= fontheight;
                        xtmpos = this.m_xChartStart;
                        labelheight += fontheight;
                        crlfdone = true;
                        remwidth = (int)d.getWidth() - this.m_xChartStart;
                    } else {
                        crlfdone = false;
                    }
                }
                remwidth -= lblwidth;
                g2d.setColor(trace.getColor());
                g2d.drawString(tmplabel, xtmpos, ytmpos);
                xtmpos += lblwidth;
            }
        }
        return labelheight;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result;
        if (pageIndex > 0) {
            result = 1;
        } else {
            this.m_pageFormat = pageFormat;
            this.updateScaling(true);
            this.printAll(graphics);
            result = 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            String property = evt.getPropertyName();
            if (!(property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("ITrace2D.PROPERTY_STROKE") || property.equals("ITrace2D.PROPERTY_COLOR") || property.equals("IAxis.PROPERTY_LABELFORMATTER"))) {
                if (property.equals(PROPERTY_ADD_REMOVE_TRACE)) {
                    this.firePropertyChange(PROPERTY_ADD_REMOVE_TRACE, evt.getOldValue(), evt.getNewValue());
                } else if (property.equals("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED")) {
                    int highlightersAddedOrRemoved = 0;
                    if (evt.getOldValue() != null) {
                        --highlightersAddedOrRemoved;
                    }
                    if (evt.getNewValue() != null) {
                        ++highlightersAddedOrRemoved;
                    }
                    this.trackHighlightingEnablement(highlightersAddedOrRemoved);
                } else if (!(property.equals("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED") || property.equals("IAxis.PROPERTY_PAINTGRID") || property.equals("IAxis.PROPERTY_RANGEPOLICY"))) {
                    throw new IllegalStateException("Received a property change event \"" + property + "\" the code is not expecting (programming error).");
                }
            }
            this.setRequestedRepaint(true);
        }
    }

    public Set<ITrace2D> removeAllTraces() {
        Set<ITrace2D> axisTraces;
        TreeSet<ITrace2D> result = new TreeSet<ITrace2D>();
        for (IAxis<?> currentAxis : this.m_axesXBottom) {
            axisTraces = currentAxis.removeAllTraces();
            result.addAll(axisTraces);
        }
        for (IAxis<?> currentAxis : this.m_axesXTop) {
            axisTraces = currentAxis.removeAllTraces();
            result.addAll(axisTraces);
            axisTraces.clear();
        }
        for (IAxis<?> currentAxis : this.m_axesYLeft) {
            axisTraces = currentAxis.removeAllTraces();
            axisTraces.clear();
        }
        for (IAxis<?> currentAxis : this.m_axesYRight) {
            axisTraces = currentAxis.removeAllTraces();
            axisTraces.clear();
        }
        return result;
    }

    public boolean removeAxisXBottom(IAxis<?> axisX) {
        boolean result = this.m_axesXBottom.remove(axisX);
        this.unlistenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, axisX, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisXTop(IAxis<?> axisX) {
        boolean result = this.m_axesXTop.remove(axisX);
        this.unlistenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, axisX, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisYLeft(IAxis<?> axisY) {
        boolean result = this.m_axesYLeft.remove(axisY);
        this.unlistenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, axisY, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisYRight(IAxis<?> axisY) {
        boolean result = this.m_axesYRight.remove(axisY);
        this.unlistenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, axisY, null);
        this.setRequestedRepaint(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeTrace(ITrace2D points) {
        boolean result = false;
        Chart2D chart2D = this;
        synchronized (chart2D) {
            ITrace2D iTrace2D = points;
            synchronized (iTrace2D) {
                boolean success;
                IAxis<?> currentAxis2;
                Iterator<IAxis<?>> it = this.m_axesXBottom.iterator();
                boolean successRemoveX = false;
                while (it.hasNext() && !(successRemoveX = (currentAxis2 = it.next()).removeTrace(points))) {
                }
                if (!successRemoveX) {
                    it = this.m_axesXTop.iterator();
                    while (it.hasNext() && !(successRemoveX = (currentAxis2 = it.next()).removeTrace(points))) {
                    }
                }
                boolean successRemoveY = false;
                for (IAxis<?> currentAxis2 : this.m_axesYLeft) {
                    successRemoveY = currentAxis2.removeTrace(points);
                }
                if (!successRemoveY) {
                    it = this.m_axesYRight.iterator();
                    while (it.hasNext() && !(successRemoveY = (currentAxis2 = it.next()).removeTrace(points))) {
                    }
                }
                boolean bl = success = successRemoveY && successRemoveX;
                if (success) {
                    int amountofremovedhighlighters = points.getPointHighlighters().size();
                    this.trackHighlightingEnablement(amountofremovedhighlighters);
                    this.unlistenToTrace(points);
                    this.setRequestedRepaint(true);
                }
                result = success;
                return result;
            }
        }
    }

    @Override
    @Deprecated
    public void repaint() {
        super.repaint();
    }

    @Override
    @Deprecated
    public void repaint(int x, int y, int width, int height) {
        super.repaint(x, y, width, height);
    }

    @Override
    @Deprecated
    public void repaint(long tm) {
        super.repaint(tm);
    }

    @Override
    @Deprecated
    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    @Override
    @Deprecated
    public void repaint(Rectangle r) {
        super.repaint(r);
    }

    public void resetPrintMode() {
        this.m_pageFormat = null;
        this.setRequestedRepaint(true);
    }

    public synchronized void setAxisTickPainter(IAxisTickPainter tickPainter) {
        this.m_axisTickPainter = tickPainter;
    }

    @Deprecated
    public List<IAxis<?>> setAxisX(AAxis<?> axisX) {
        LinkedList axesBottom = new LinkedList();
        for (IAxis<?> axis : this.m_axesXBottom) {
            axesBottom.add(axis);
        }
        LinkedList axesTop = new LinkedList();
        for (IAxis<Object> axis : this.m_axesXTop) {
            axesTop.add(axis);
        }
        for (IAxis<Object> axis : axesBottom) {
            this.removeAxisXBottom(axis);
        }
        for (IAxis<Object> axis : axesTop) {
            this.removeAxisXTop(axis);
        }
        axesBottom.addAll(axesTop);
        return axesBottom;
    }

    public IAxis<?> setAxisXBottom(AAxis<?> axisX, int position) {
        IAxis<?> old = null;
        if (this.m_axesXBottom.size() > position) {
            old = this.m_axesXBottom.get(position);
            this.removeAxisXBottom(old);
            this.firePropertyChange(PROPERTY_AXIS_X_BOTTOM_REPLACE, old, axisX);
        }
        this.addAxisXBottom(axisX);
        if (old != null) {
            this.internalTransferAxisState(old, axisX);
        }
        this.m_mouseTranslationXAxis = axisX;
        this.setRequestedRepaint(true);
        return old;
    }

    public IAxis<?> setAxisXTop(AAxis<?> axisX, int position) {
        IAxis<?> old = null;
        if (this.m_axesXTop.size() > position) {
            old = this.m_axesXTop.get(position);
            this.removeAxisXTop(old);
            this.firePropertyChange(PROPERTY_AXIS_X_TOP_REPLACE, old, axisX);
        }
        if (old != null) {
            this.internalTransferAxisState(old, axisX);
        }
        this.addAxisXTop(axisX);
        this.m_mouseTranslationXAxis = axisX;
        this.setRequestedRepaint(true);
        return old;
    }

    @Deprecated
    public List<IAxis<?>> setAxisY(AAxis<?> axisY) {
        LinkedList axesLeft = new LinkedList();
        for (IAxis<?> axis : this.m_axesYLeft) {
            axesLeft.add(axis);
        }
        LinkedList axesRight = new LinkedList();
        for (IAxis<Object> axis : this.m_axesYRight) {
            axesRight.add(axis);
        }
        for (IAxis<Object> axis : axesLeft) {
            this.removeAxisYLeft(axis);
        }
        for (IAxis<Object> axis : axesRight) {
            this.removeAxisYRight(axis);
        }
        axesLeft.addAll(axesRight);
        return axesLeft;
    }

    public IAxis<?> setAxisYLeft(AAxis<?> axisY, int position) {
        IAxis<?> old = null;
        if (this.m_axesYLeft.size() > position) {
            old = this.m_axesYLeft.get(position);
            this.removeAxisYLeft(old);
            this.firePropertyChange(PROPERTY_AXIS_Y_LEFT_REPLACE, old, axisY);
        }
        this.addAxisYLeft(axisY);
        if (old != null) {
            this.internalTransferAxisState(old, axisY);
        }
        this.m_mouseTranslationYAxis = axisY;
        this.setRequestedRepaint(true);
        return old;
    }

    public IAxis<?> setAxisYRight(AAxis<?> axisY, int position) {
        IAxis<?> old = null;
        if (this.m_axesYRight.size() > position) {
            old = this.m_axesYRight.get(position);
            this.removeAxisYLeft(old);
            this.firePropertyChange(PROPERTY_AXIS_Y_RIGHT_REPLACE, old, axisY);
        }
        this.addAxisYRight(axisY);
        if (old != null) {
            this.internalTransferAxisState(old, axisY);
        }
        this.m_mouseTranslationYAxis = axisY;
        this.setRequestedRepaint(true);
        return old;
    }

    public final void setGridColor(Color gridclr) {
        if (gridclr != null) {
            Color old = this.m_gridcolor;
            this.m_gridcolor = gridclr;
            if (!old.equals(this.m_gridcolor)) {
                this.firePropertyChange(PROPERTY_GRID_COLOR, old, this.m_gridcolor);
            }
            this.setRequestedRepaint(true);
        }
    }

    public synchronized void setMinPaintLatency(int minPaintLatency) {
        this.m_minPaintLatency = minPaintLatency;
        this.m_repainter.setDelay(this.m_minPaintLatency);
    }

    public void setPaintLabels(boolean paintLabels) {
        boolean change = this.m_paintLabels != paintLabels;
        this.m_paintLabels = paintLabels;
        if (change) {
            this.firePropertyChange(PROPERTY_PAINTLABELS, new Boolean(!paintLabels), new Boolean(paintLabels));
            this.setRequestedRepaint(true);
        }
    }

    public void setPointFinder(IPointFinder pointFinder) {
        IPointFinder old = this.m_pointFinder;
        if (!this.m_pointFinder.equals(pointFinder)) {
            this.m_pointFinder = pointFinder;
            this.firePropertyChange(PROPERTY_POINTFINDER, old, this.m_pointFinder);
        }
    }

    public final synchronized void setRequestedRepaint(boolean requestedRepaint) {
        this.m_requestedRepaint = requestedRepaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSynchronizedXStartChart(Chart2D synchronizedXStartChart) {
        this.m_synchronizedXStartChart = synchronizedXStartChart;
        this.m_synchronizedXStart = false;
        Chart2D chart2D = synchronizedXStartChart;
        synchronized (chart2D) {
            synchronizedXStartChart.m_synchronizedXStart = true;
        }
    }

    @Deprecated
    public final void setToolTipCoords(boolean toolTipCoords) {
        if (toolTipCoords) {
            this.setToolTipType(ToolTipType.DATAVALUES);
        } else {
            this.setToolTipType(ToolTipType.NONE);
        }
    }

    public final void setToolTipType(IToolTipType toolTipType) {
        if (toolTipType == ToolTipType.NONE) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("turnOn");
        }
        IToolTipType old = this.m_toolTip;
        this.m_toolTip = toolTipType;
        this.firePropertyChange(PROPERTY_TOOLTIP_TYPE, old, this.m_toolTip);
    }

    public void setTracePointProvider(ITracePointProvider tracePointProvider) {
        assert (tracePointProvider != null);
        this.m_tracePointProvider = tracePointProvider;
    }

    public final void setUseAntialiasing(boolean useAntialiasing) {
        if (this.m_useAntialiasing != useAntialiasing) {
            boolean oldstate = this.m_useAntialiasing;
            this.m_useAntialiasing = useAntialiasing;
            this.firePropertyChange(PROPERTY_ANTIALIASING_ENABLED, oldstate, this.m_useAntialiasing);
        }
    }

    public BufferedImage snapShot() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 && height <= 0) {
            width = 600;
            height = 400;
        }
        return this.snapShot(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage snapShot(int width, int height) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            Dimension dsave = new Dimension(this.getWidth(), this.getHeight());
            this.setSize(new Dimension(width, height));
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D g2d = (Graphics2D)img.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(g2d);
            this.setSize(dsave);
            return img;
        }
    }

    @Override
    public String toString() {
        String result = super.toString();
        return result;
    }

    private void trackHighlightingEnablement(int addedOrRemovedTraceHighlighters) {
        if (this.m_traceHighlighterCount <= 0) {
            if (addedOrRemovedTraceHighlighters > 0) {
                this.enablePointHighlighting(true);
            }
        } else if (addedOrRemovedTraceHighlighters < 0 && Math.abs(addedOrRemovedTraceHighlighters) >= this.m_traceHighlighterCount) {
            this.enablePointHighlighting(false);
        }
        this.m_traceHighlighterCount += addedOrRemovedTraceHighlighters;
        if (this.m_traceHighlighterCount < 0) {
            System.err.println("Internal amount of point highlighters below zero: " + this.m_traceHighlighterCount);
        }
    }

    @Deprecated
    public ITracePoint2D translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        if (mouseEvent.getSource() != this) {
            throw new IllegalArgumentException("The given mouse event does not belong to this chart but to: " + mouseEvent.getSource());
        }
        ITracePoint2D result = null;
        double valueX = this.m_mouseTranslationXAxis.translateMousePosition(mouseEvent);
        double valueY = this.m_mouseTranslationYAxis.translateMousePosition(mouseEvent);
        result = this.m_tracePointProvider.createTracePoint(valueX, valueY);
        return result;
    }

    private void unlistenToAxis(IAxis<?> removedAxis) {
        removedAxis.removePropertyChangeListener(PROPERTY_ADD_REMOVE_TRACE, this);
        removedAxis.removePropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        removedAxis.removePropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        removedAxis.removePropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
        removedAxis.removePropertyChangeListener("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", this);
    }

    private void unlistenToTrace(ITrace2D removedTrace) {
        removedTrace.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this.m_pointHighlightListener);
        removedTrace.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
    }

    private synchronized void updateScaling(boolean force) {
        boolean changed;
        for (IAxis<?> currentAxis : this.m_axesXBottom) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis<?> currentAxis : this.m_axesXTop) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis<?> currentAxis : this.m_axesYLeft) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis<?> currentAxis : this.m_axesYRight) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
    }

    final class PointHighlighter
    extends MouseMotionAdapter
    implements MouseMotionListener,
    PropertyChangeListener {
        private Map<ITrace2D, ITracePoint2D> m_previousHighlighted = new IdentityHashMap<ITrace2D, ITracePoint2D>();

        public PointHighlighter() {
            Chart2D.this.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
            Chart2D.this.addPropertyChangeListener(Chart2D.PROPERTY_ADD_REMOVE_TRACE, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setActive(boolean onoff) {
            boolean result = false;
            boolean isEnabled = Chart2D.this.isEnabledPointHighlighting();
            if (!onoff) {
                if (isEnabled) {
                    Chart2D chart2D = Chart2D.this;
                    synchronized (chart2D) {
                        for (Map.Entry<ITrace2D, ITracePoint2D> entry : this.m_previousHighlighted.entrySet()) {
                            ITrace2D iTrace2D = entry.getKey();
                            synchronized (iTrace2D) {
                                Set<IPointPainter<?>> highlighters = entry.getKey().getPointHighlighters();
                                Set<IPointPainter<?>> additionalPainters = entry.getValue().getAdditionalPointPainters();
                                Iterator<IPointPainter<?>> itAdditionasPainters = additionalPainters.iterator();
                                block10: while (itAdditionasPainters.hasNext()) {
                                    IPointPainter<?> assignedHighlighter = itAdditionasPainters.next();
                                    for (IPointPainter<?> highlighter : highlighters) {
                                        if (assignedHighlighter != highlighter) continue;
                                        itAdditionasPainters.remove();
                                        continue block10;
                                    }
                                }
                            }
                        }
                        Chart2D.this.removeMouseMotionListener(this);
                        Chart2D.this.firePropertyChange(Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED, Boolean.TRUE, Boolean.FALSE);
                        this.m_previousHighlighted.clear();
                        Chart2D.this.setRequestedRepaint(true);
                        result = true;
                    }
                }
            } else if (!isEnabled) {
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    Chart2D.this.addMouseMotionListener(this);
                    Chart2D.this.firePropertyChange(Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED, Boolean.FALSE, Boolean.TRUE);
                    Chart2D.this.setRequestedRepaint(true);
                    result = true;
                }
            }
            return result;
        }

        private void attachHighlighters(ITracePoint2D point) {
            ITrace2D trace = point.getListener();
            for (IPointPainter<?> highlighter : trace.getPointHighlighters()) {
                point.addAdditionalPointPainter(highlighter);
            }
        }

        private void clearOutdatedHighlighters(ITrace2D trace) {
            ITracePoint2D previousHighlightedPoint = this.m_previousHighlighted.remove(trace);
            if (previousHighlightedPoint != null) {
                Iterator<IPointPainter<?>> itAdditionaPainters = previousHighlightedPoint.getAdditionalPointPainters().iterator();
                Set<IPointPainter<?>> highlighters = trace.getPointHighlighters();
                block0: while (itAdditionaPainters.hasNext()) {
                    IPointPainter<?> additionalPainter = itAdditionaPainters.next();
                    for (IPointPainter<?> highlighter : highlighters) {
                        if (highlighter != additionalPainter) continue;
                        itAdditionaPainters.remove();
                        continue block0;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent e) {
            ITracePoint2D previousHighlightedPoint;
            ITracePoint2D point = Chart2D.this.getPointFinder().getNearestPoint(e, Chart2D.this);
            if (point != null && !point.equals(previousHighlightedPoint = this.m_previousHighlighted.get(point.getListener()))) {
                ITrace2D trace = point.getListener();
                PointHighlighter pointHighlighter = this;
                synchronized (pointHighlighter) {
                    ITrace2D iTrace2D = trace;
                    synchronized (iTrace2D) {
                        this.clearOutdatedHighlighters(trace);
                        this.attachHighlighters(point);
                        this.m_previousHighlighted.put(trace, point);
                        Chart2D.this.setRequestedRepaint(true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED".equals(property)) {
                ITrace2D trace = (ITrace2D)evt.getSource();
                ITracePoint2D point = this.m_previousHighlighted.get(trace);
                if (point == null) return;
                if (evt.getNewValue() != null && evt.getOldValue() == null) {
                    if (this.m_previousHighlighted == null) return;
                    Chart2D chart2D = Chart2D.this;
                    synchronized (chart2D) {
                        ITrace2D iTrace2D = trace;
                        synchronized (iTrace2D) {
                            point.addAdditionalPointPainter((IPointPainter)evt.getNewValue());
                            Chart2D.this.setRequestedRepaint(true);
                        }
                        return;
                    }
                }
                if (evt.getNewValue() != null || evt.getOldValue() == null) throw new RuntimeException("Programming error. Unneccessary event caught: " + evt + ". You only have to fire this event, if a point highlighter was addded or removed.");
                if (this.m_previousHighlighted == null) return;
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    ITrace2D iTrace2D = trace;
                    synchronized (iTrace2D) {
                        point.removeAdditionalPointPainter((IPointPainter)evt.getOldValue());
                        Chart2D.this.setRequestedRepaint(true);
                    }
                    return;
                }
            }
            if (!Chart2D.PROPERTY_ADD_REMOVE_TRACE.equals(property)) throw new RuntimeException("Programming error: " + this.getClass().getName() + " only has to be registered to the event " + "ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED" + " on instances of type (or subtype) " + ITrace2D.class.getName());
            ITrace2D oldTrace2d = (ITrace2D)evt.getOldValue();
            if (evt.getNewValue() != null) return;
            this.m_previousHighlighted.remove(oldTrace2d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolTipType implements IToolTipType
    {
        DATAVALUES{

            public String getDescription() {
                return "Value at cursor (rel. to 1st trace)";
            }

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                ITracePoint2D tracePoint = chart.translateMousePosition(me);
                StringBuffer buffer = new StringBuffer("X: ");
                buffer.append(chart.getAxisX().getFormatter().format(tracePoint.getX())).append(" ");
                buffer.append("Y: ");
                buffer.append(chart.getAxisY().getFormatter().format(tracePoint.getY()));
                String result = buffer.toString();
                return result;
            }
        }
        ,
        NONE,
        PIXEL{

            public String getDescription() {
                return "Pixel, not implemented yet";
            }

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                return "pixel, not implemented yet";
            }
        }
        ,
        VALUE_SNAP_TO_TRACEPOINTS{

            public String getDescription() {
                return "Values, snap to nearest point";
            }

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                ITracePoint2D point = chart.getPointFinder().getNearestPoint(me, chart);
                ITrace2D trace = point.getListener();
                IAxis<?> xAxis = chart.getAxisX(trace);
                IAxis<?> yAxis = chart.getAxisY(trace);
                chart.setRequestedRepaint(true);
                StringBuffer buffer = new StringBuffer("X: ");
                buffer.append(xAxis.getFormatter().format(point.getX())).append(" ");
                buffer.append("Y: ");
                buffer.append(yAxis.getFormatter().format(point.getY()));
                String result = buffer.toString();
                return result;
            }
        };


        @Override
        public String getDescription() {
            return "None";
        }

        @Override
        public String getToolTipText(Chart2D chart, MouseEvent me) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointFinder implements IPointFinder
    {
        EUCLID{

            public ITracePoint2D getNearestPoint(int mouseEventX, int mouseEventY, Chart2D chart) {
                return chart.getNearestPointEuclid(mouseEventX, mouseEventY);
            }
        }
        ,
        MANHATTAN{

            public ITracePoint2D getNearestPoint(int mouseEventX, int mouseEventY, Chart2D chart) {
                return chart.getNearestPointManhattan(mouseEventX, mouseEventY);
            }
        };


        @Override
        public ITracePoint2D getNearestPoint(MouseEvent me, Chart2D chart) {
            return this.getNearestPoint(me.getX(), me.getY(), chart);
        }
    }
}

