/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.io.AStaticDataCollector;
import info.monitorenter.gui.chart.io.PropertyFileStaticDataCollector;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartCoordinateView;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;

public class CoordinateViewChart
extends JFrame {
    private Chart2D m_chart;

    public static void main(String[] args) throws IOException {
        Chart2D chart = new Chart2D();
        chart.enablePointHighlighting(true);
        chart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        Trace2DLtd trace = new Trace2DLtd(400);
        PropertyFileStaticDataCollector collector = new PropertyFileStaticDataCollector(trace, CoordinateViewChart.class.getResourceAsStream("data.properties"));
        chart.addTrace(trace);
        trace.setPointHighlighter(new PointPainterDisc(10));
        ((AStaticDataCollector)collector).collectData();
        new CoordinateViewChart(chart);
    }

    public CoordinateViewChart(Chart2D chart) {
        super("View coordinates");
        this.m_chart = chart;
        ChartCoordinateView viewChartValue = new ChartCoordinateView(this.m_chart);
        new LayoutFactory.BasicPropertyAdaptSupport(viewChartValue, this.m_chart, LayoutFactory.BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        new LayoutFactory.BasicPropertyAdaptSupport(contentPane, this.m_chart, LayoutFactory.BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.bottom = 8;
        gbc.anchor = 11;
        gbc.fill = 1;
        contentPane.add((Component)new ChartPanel(this.m_chart), gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.insets.bottom = 0;
        gbc.anchor = 11;
        gbc.fill = 0;
        contentPane.add((Component)viewChartValue, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setSize(new Dimension(400, 300));
        this.setVisible(true);
    }
}

