/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class LabelFormatterNumber
extends ALabelFormatter
implements IAxisLabelFormatter {
    private double m_cachedMinValueShift = Double.MAX_VALUE;
    protected NumberFormat m_numberFormat;

    public LabelFormatterNumber() {
        this.m_numberFormat = new DecimalFormat();
    }

    public LabelFormatterNumber(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Argument numberFormat must not be null.");
        }
        this.setNumberFormat(numberFormat);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelFormatterNumber other = (LabelFormatterNumber)obj;
        if (Double.doubleToLongBits(this.m_cachedMinValueShift) != Double.doubleToLongBits(other.m_cachedMinValueShift)) {
            return false;
        }
        return !(this.m_numberFormat == null ? other.m_numberFormat != null : !this.m_numberFormat.equals(other.m_numberFormat));
    }

    public String format(double value) {
        return this.m_numberFormat.format(value);
    }

    public int getMaxAmountChars() {
        int maxMaxLength = this.format(this.getAxis().getMax()).length();
        int minMaxLength = this.format(this.getAxis().getMin()).length();
        int result = Math.max(maxMaxLength, minMaxLength);
        return result += this.m_numberFormat.getMaximumFractionDigits();
    }

    public double getMinimumValueShiftForChange() {
        if (this.m_cachedMinValueShift == Double.MAX_VALUE) {
            int fractionDigits = this.m_numberFormat.getMaximumFractionDigits();
            this.m_cachedMinValueShift = 1.0 / Math.pow(10.0, fractionDigits);
        }
        return this.m_cachedMinValueShift;
    }

    public double getNextEvenValue(double value, boolean ceiling) {
        double divisor = Math.pow(10.0, this.m_numberFormat.getMaximumFractionDigits());
        double result = ceiling ? Math.ceil(value * divisor) / divisor : Math.floor(value * divisor) / divisor;
        return result;
    }

    public NumberFormat getNumberFormat() {
        return this.m_numberFormat;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.m_cachedMinValueShift);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.m_numberFormat == null ? 0 : this.m_numberFormat.hashCode());
        return result;
    }

    public Number parse(String formatted) throws NumberFormatException {
        try {
            return this.m_numberFormat.parse(formatted);
        }
        catch (ParseException pe) {
            throw new NumberFormatException(pe.getMessage());
        }
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat old = this.m_numberFormat;
        this.m_numberFormat = numberFormat;
        this.m_propertyChangeSupport.firePropertyChange("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", old, this.m_numberFormat);
    }
}

