/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli \
 *     --scli-include='historyControlEntry' RMON-MIB
 *
 * Derived from RMON-MIB:
 *   Remote network monitoring devices, often called
 *   monitors or probes, are instruments that exist for
 *   the purpose of managing a network. This MIB defines
 *   objects for managing remote network monitoring devices.
 *
 * Revision 2000-05-11 00:00:
 *   Reformatted into SMIv2 format.
 *   
 *   This version published as RFC 2819.
 *
 * Revision 1995-02-01 00:00:
 *   Bug fixes, clarifications and minor changes based on
 *   implementation experience, published as RFC1757 [18].
 *   
 *   Two changes were made to object definitions:
 *   
 *   1) A new status bit has been defined for the
 *   captureBufferPacketStatus object, indicating that the
 *   packet order within the capture buffer may not be identical to
 *   the packet order as received off the wire.  This bit may only
 *   be used for packets transmitted by the probe.  Older NMS
 *   applications can safely ignore this status bit, which might be
 *   used by newer agents.
 *   
 *   2) The packetMatch trap has been removed.  This trap was never
 *   actually 'approved' and was not added to this document along
 *   with the risingAlarm and fallingAlarm traps. The packetMatch
 *   trap could not be throttled, which could cause disruption of
 *   normal network traffic under some circumstances. An NMS should
 *   configure a risingAlarm threshold on the appropriate
 *   channelMatches instance if a trap is desired for a packetMatch
 *   event. Note that logging of packetMatch events is still
 *   supported--only trap generation for such events has been
 *   removed.
 *   
 *   In addition, several clarifications to individual object
 *   definitions have been added to assist agent and NMS
 *   implementors:
 *   
 *   - global definition of 'good packets' and 'bad packets'
 *   
 *   - more detailed text governing conceptual row creation and
 *     modification
 *   
 *   - instructions for probes relating to interface changes and
 *     disruptions
 *   
 *   - clarification of some ethernet counter definitions
 *   
 *   - recommended formula for calculating network utilization
 *   
 *   - clarification of channel and captureBuffer behavior for some
 *     unusual conditions
 *   
 *   - examples of proper instance naming for each table
 *
 * Revision 1991-11-01 00:00:
 *   The original version of this MIB, published as RFC1271.
 *
 * $Id: rmon-mib.h 3180 2009-07-29 22:36:13Z schoenw $
 */

#ifndef _RMON_MIB_H_
#define _RMON_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define RMON_MIB_ENTRYSTATUS_VALID         1
#define RMON_MIB_ENTRYSTATUS_CREATEREQUEST 2
#define RMON_MIB_ENTRYSTATUS_UNDERCREATION 3
#define RMON_MIB_ENTRYSTATUS_INVALID       4

extern GNetSnmpEnum const rmon_mib_enums_EntryStatus[];


/*
 * Tables to map notifications to strings and vice versa.
 */

#define RMON_MIB_RISINGALARM	1,3,6,1,2,1,16,0,1
#define RMON_MIB_FALLINGALARM	1,3,6,1,2,1,16,0,2

extern GNetSnmpIdentity const rmon_mib_notifications[];

/*
 * C type definitions for RMON-MIB::historyControlEntry.
 */

#define RMON_MIB_HISTORYCONTROLINDEX            (1 << 0) 
#define RMON_MIB_HISTORYCONTROLDATASOURCE       (1 << 1) 
#define RMON_MIB_HISTORYCONTROLBUCKETSREQUESTED (1 << 2) 
#define RMON_MIB_HISTORYCONTROLBUCKETSGRANTED   (1 << 3) 
#define RMON_MIB_HISTORYCONTROLINTERVAL         (1 << 4) 
#define RMON_MIB_HISTORYCONTROLOWNER            (1 << 5) 
#define RMON_MIB_HISTORYCONTROLSTATUS           (1 << 6) 

typedef struct {
    gint32   historyControlIndex;                 /* ro */
    guint32  *historyControlDataSource;           /* rw ObjectIdentifier */
#define RMON_MIB_HISTORYCONTROLDATASOURCEMINLENGTH 0
#define RMON_MIB_HISTORYCONTROLDATASOURCEMAXLENGTH 128
    guint16  _historyControlDataSourceLength;
    gint32   *historyControlBucketsRequested;     /* rw */
    gint32   *historyControlBucketsGranted;       /* ro */
    gint32   *historyControlInterval;             /* rw [Seconds] */
    guchar   *historyControlOwner;                /* rw RMON-MIB::OwnerString */
#define RMON_MIB_HISTORYCONTROLOWNERMINLENGTH 0
#define RMON_MIB_HISTORYCONTROLOWNERMAXLENGTH 127
    guint16  _historyControlOwnerLength;
    gint32   *historyControlStatus;               /* rw RMON-MIB::EntryStatus */
} rmon_mib_historyControlEntry_t;

extern void
rmon_mib_get_historyControlTable(GNetSnmp *s, rmon_mib_historyControlEntry_t ***historyControlEntry, gint64 mask, GError **error);

extern void
rmon_mib_free_historyControlTable(rmon_mib_historyControlEntry_t **historyControlEntry);

extern rmon_mib_historyControlEntry_t *
rmon_mib_new_historyControlEntry(void);

extern void
rmon_mib_get_historyControlEntry(GNetSnmp *s, rmon_mib_historyControlEntry_t **historyControlEntry, gint32 historyControlIndex, gint64 mask, GError **error);

extern void
rmon_mib_set_historyControlEntry(GNetSnmp *s, rmon_mib_historyControlEntry_t *historyControlEntry, gint64 mask, GError **error);

extern void
rmon_mib_free_historyControlEntry(rmon_mib_historyControlEntry_t *historyControlEntry);


G_END_DECLS

#endif /* _RMON_MIB_H_ */
