#version 330


layout(points) in;
layout(triangle_strip, max_vertices = 103) out;
//layout(line_strip, max_vertices = 80) out;

// input position and color
uniform vec4 Color;
uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform int inFocus = -1;
uniform vec3 fcoord = vec3(0);
uniform vec3 origin = vec3(0);
uniform float selrad = 0.35;

out vec3 Normal;
out vec3 nor;

out gl_PerVertex{
  vec4 gl_Position;
};


void icosa(float r){
  const float phi = (1.0 + sqrt(5.0)) / 2.0;
  const float du = 1.0 / sqrt(phi * phi + 1.0);
  const float dv = phi * du;  
  //const float ang = 140.0 /180.0 *3.141592654;
  /*mat4(
  vec4( cos(angle),        0, sin(angle), 0),
  vec4(        0,        1,        0, 0),
  vec4(-sin(angle),        0, cos(angle), 0),
  vec4(        0,        0,        0, 1));*/
  //mat4 rot = rmat(vec4(angle, normalize(vec3(1,1,0))));
  const vec3  eckn[] = vec3[12](
                          vec3(0.0, dv, du),   vec3(0.0, dv, -du),  vec3(0.0, -dv, du),
                          vec3(0.0, -dv, -du), vec3(du, 0.0, dv),   vec3(-du, 0.0, dv),
                          vec3(du, 0.0, -dv),  vec3(-du, 0.0, -dv), vec3(dv, du, 0.0),
                          vec3(dv, -du, 0.0),  vec3(-dv, du, 0.0),  vec3(-dv, -du, 0.0));
  const int triangle[] = int[60](
    1, 0, 8,
    4, 0, 5,
    5, 0, 10,
    8, 0, 4,
   10, 0, 1,
    6, 1, 8,
    7, 1, 6,
   10, 1, 7,
    3, 2, 11,
    4, 2, 9,
    5, 2, 4,
    9, 2, 3,
   11, 2, 5,
    6, 3, 7,
    7, 3, 11,
    9, 3, 6,
    8, 4, 9,
   11, 5, 10,
    9, 6, 8,
   10, 7, 11);
  vec3 _nor;
  for (int j=0; j<triangle.length(); j++){
      gl_Position = pmv*(gl_in[0].gl_Position + (vec4(r * eckn[triangle[j]], 0.0)));
      if ((j%3 == 0)&&((j+2) < triangle.length())) _nor = normalize(eckn[triangle[j]]+eckn[triangle[j+1]]+eckn[triangle[j+2]]);
      Normal =  normalize(normalMatrix * _nor);
      nor = eckn[triangle[j]];
      EmitVertex();
    if (j%3 == 2)EndPrimitive();
  }
// */
//*
  /*const int strip[] = int[37](0, 1, 8, 0, 4, 5, 0, 10, 5, 11, 2, 3, 9, 6, 3, 7, 6, 1, 8,
    6, 9, 8, 4, 9, 2, 4, 5, 2, 11, 3, 7, 11, 10, 7, 1, 10, 0);
  for (int i=0; i< strip.length(); i++){
    gl_Position = pmv*(gl_in[0].gl_Position + (vec4(r * eckn[strip[i]], 0.0)));
    if (i+2 < strip.length()) nor = normalize(eckn[strip[i]]+eckn[strip[i+1]]+eckn[strip[i+2]]);
    Normal =  normalize(normalMatrix * nor);
    EmitVertex();
  }// */
  EndPrimitive();
}

void icosa(float r, vec4 pos){
  const float phi = (1.0 + sqrt(5.0)) / 2.0;
  const float du = 1.0 / sqrt(phi * phi + 1.0);
  const float dv = phi * du;
  //const float ang = 140.0 /180.0 *3.141592654;
  /*mat4(
  vec4( cos(angle),        0, sin(angle), 0),
  vec4(        0,        1,        0, 0),
  vec4(-sin(angle),        0, cos(angle), 0),
  vec4(        0,        0,        0, 1));*/
  //mat4 rot = rmat(vec4(angle, normalize(vec3(1,1,0))));
  const vec3  eckn[] = vec3[12](
                          vec3(0.0, dv, du),   vec3(0.0, dv, -du),  vec3(0.0, -dv, du),
                          vec3(0.0, -dv, -du), vec3(du, 0.0, dv),   vec3(-du, 0.0, dv),
                          vec3(du, 0.0, -dv),  vec3(-du, 0.0, -dv), vec3(dv, du, 0.0),
                          vec3(dv, -du, 0.0),  vec3(-dv, du, 0.0),  vec3(-dv, -du, 0.0));
  const int triangle[] = int[60](
    1, 0, 8,
    4, 0, 5,
    5, 0, 10,
    8, 0, 4,
   10, 0, 1,
    6, 1, 8,
    7, 1, 6,
   10, 1, 7,
    3, 2, 11,
    4, 2, 9,
    5, 2, 4,
    9, 2, 3,
   11, 2, 5,
    6, 3, 7,
    7, 3, 11,
    9, 3, 6,
    8, 4, 9,
   11, 5, 10,
    9, 6, 8,
   10, 7, 11);
  vec3 _nor;
  for (int j=0; j<triangle.length(); j++){
      gl_Position = pmv*(pos + (vec4(r * -eckn[triangle[j]], 0.0)));
      if ((j%3 == 0)&&((j+2) < triangle.length())) _nor = normalize(-eckn[triangle[j]]-eckn[triangle[j+1]]-eckn[triangle[j+2]]);
      Normal =  normalize(normalMatrix * _nor);
      nor = eckn[triangle[j]];
      EmitVertex();
    if (j%3 == 2)EndPrimitive();
  }
// */
//*
  /*const int strip[] = int[37](0, 1, 8, 0, 4, 5, 0, 10, 5, 11, 2, 3, 9, 6, 3, 7, 6, 1, 8,
    6, 9, 8, 4, 9, 2, 4, 5, 2, 11, 3, 7, 11, 10, 7, 1, 10, 0);
  for (int i=0; i< strip.length(); i++){
    gl_Position = pmv*(gl_in[0].gl_Position + (vec4(r * eckn[strip[i]], 0.0)));
    if (i+2 < strip.length()) nor = normalize(eckn[strip[i]]+eckn[strip[i+1]]+eckn[strip[i+2]]);
    Normal =  normalize(normalMatrix * nor);
    EmitVertex();
  }// */
  EndPrimitive();
}

void main() {
    if (inFocus==-1){
        icosa(selrad);
    } else if (inFocus==-2){
        icosa(0.5);
    } else {
        icosa(0.4, vec4(fcoord-origin,1));
    }
}
