#ifndef SimTK_SIMBODY_MOBILIZED_BODY_BUILTINS_H_
#define SimTK_SIMBODY_MOBILIZED_BODY_BUILTINS_H_

/* -------------------------------------------------------------------------- *
 *                               Simbody(tm)                                  *
 * -------------------------------------------------------------------------- *
 * This is part of the SimTK biosimulation toolkit originating from           *
 * Simbios, the NIH National Center for Physics-Based Simulation of           *
 * Biological Structures at Stanford, funded under the NIH Roadmap for        *
 * Medical Research, grant U54 GM072970. See https://simtk.org/home/simbody.  *
 *                                                                            *
 * Portions copyright (c) 2012 Stanford University and the Authors.           *
 * Authors: Michael Sherman                                                   *
 * Contributors:                                                              *
 *                                                                            *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may    *
 * not use this file except in compliance with the License. You may obtain a  *
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0.         *
 *                                                                            *
 * Unless required by applicable law or agreed to in writing, software        *
 * distributed under the License is distributed on an "AS IS" BASIS,          *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   *
 * See the License for the specific language governing permissions and        *
 * limitations under the License.                                             *
 * -------------------------------------------------------------------------- */

/** @file
Include the header files that define each of the built-in mobilizer
subclasses of MobilizedBody. **/

#include "simbody/internal/MobilizedBody_Ball.h"
#include "simbody/internal/MobilizedBody_BendStretch.h"
#include "simbody/internal/MobilizedBody_Bushing.h"
#include "simbody/internal/MobilizedBody_Custom.h"
#include "simbody/internal/MobilizedBody_Cylinder.h"
#include "simbody/internal/MobilizedBody_Ellipsoid.h"
#include "simbody/internal/MobilizedBody_Free.h"
#include "simbody/internal/MobilizedBody_FreeLine.h"
#include "simbody/internal/MobilizedBody_FunctionBased.h"
#include "simbody/internal/MobilizedBody_Gimbal.h"
#include "simbody/internal/MobilizedBody_Ground.h"
#include "simbody/internal/MobilizedBody_LineOrientation.h"
#include "simbody/internal/MobilizedBody_Pin.h"
#include "simbody/internal/MobilizedBody_Planar.h"
#include "simbody/internal/MobilizedBody_Screw.h"
#include "simbody/internal/MobilizedBody_Slider.h"
#include "simbody/internal/MobilizedBody_SphericalCoords.h"
#include "simbody/internal/MobilizedBody_Translation.h"
#include "simbody/internal/MobilizedBody_Universal.h"
#include "simbody/internal/MobilizedBody_Weld.h"

#endif // SimTK_SIMBODY_MOBILIZED_BODY_BUILTINS_H_



