# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/sst_from_xml.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Conversion script from kdissert .kdi to sisu markup .ssm
    (master document)

=end
module SiSU_sstFromXML
  require_relative 'sysenv'                             # sysenv.rb
  class Convert
    begin
      require 'rexml/document'
        include REXML
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('rexml/document NOT FOUND (LoadError)')
    end
    def initialize(opt)
      @opt=opt
      @sisu,@sisu_base=[],[]
      @ver=SiSU_Env::InfoVersion.instance.get_version
    end
    def tell(filename,type)
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],"XML #{type} to SiSU sst","#{filename} --> #{filename}.sst").green_hi_blue
    end
    def read
      xml_to_sisu
    end
    def markup_head(text)
      text.strip!
      text.gsub!(/(?:\s*\n|\s\s+)/,' ')
      text.gsub!(/<header class=['"]\S+?['"]>(.+?)<\/header>/,'\1')
      text.gsub!(/<(\w+)>(.+?)<\/\w+>/,'@\1: \2')
      text.gsub!(/<header class=['"]\S+?['"]><(\w+)>(.+?)<\/\w+><\/header>/,'@\1: \2')
      text.gsub!(/\s +/,' ')
      text.strip!
      text + "\n\n"
    end
    def markup(text)
      text.strip!
      text.gsub!(/(?:\s*\n|\s\s+)/,' ')
      text.gsub!(/<text class='h1'>(.+?)<\/text>/,':A~ \1')
      text.gsub!(/<text class='h2'>(.+?)<\/text>/,':B~ \1')
      text.gsub!(/<text class='h3'>(.+?)<\/text>/,':C~ \1')
      text.gsub!(/<text class='h4'>(.+?)<\/text>/,'1~ \1')
      text.gsub!(/<text class='h5'>(.+?)<\/text>/,'2~ \1')
      text.gsub!(/<text class='h6'>(.+?)<\/text>/,'3~ \1')
      text.gsub!(/<text class='norm'>(.+?)<\/text>/,'\1')
      text.gsub!(/<endnote symbol='norm'>(.+?)<\/endnote>/,'~{ \1 }~')
      text.gsub!(/<br ?\/>/,'<br>')
      text.gsub!(/<i>(.+?)<\/i>/,'/{\1}/')
      text.gsub!(/<b>(.+?)<\/b>/,'*{\1}*')
      text.gsub!(/<u>(.+?)<\/u>/,'_{\1}_')
      text.gsub!(/<sem:([a-z_]+)\s+depth=['"]zero['"]>(\s*.+?\s*)<\/sem:\1>/,';{ \2 };\1')
      text.gsub!(/<sem:([a-z_]+)\s+depth=['"]one['"]>(\s*.+?\s*)<\/sem:\1>/,':{ \2 }:\1')
      text.gsub!(/<sem:([a-z_]+)\s+depth=['"]many['"]>(\s*.+?\s*)<\/sem:\1>/,'\1:{ \2 }:\1')
      text.gsub!(/<sem:([a-z_]+)>(\s*.+?\s*)<\/sem:\1>/,'\1:{ \2 }:\1')
      text.gsub!(/\s +/,' ')
      text.strip!
      text + "\n\n"
    end
    def sax
      out_file=File.new(@output_file_name,'w')
      head=@doc.root.get_elements('//head/header')
      body=@doc.root.get_elements('//object/text')
      out_file.puts "% SiSU text #{@ver[:version]} (generated from a SiSU XML markup representation)\n\n"
      head.each do |x|
        if x.name=='header'
          head=markup_head(x.to_s)
          out_file.puts head
        end
      end
      body.each do |x|
        if x.name=='text'
          body=markup(x.to_s)
          out_file.puts body
        end
      end
    end
    def node
      sax
    end
    def dom
      raise "#{__FILE__}::#{__LINE__} xml dom representation to sst not yet implemented (experimental simple xml representations sax and node to sst are in place)."
    end
    def xml_to_sisu
      unless @opt.files.empty?
        @opt.files.each do |xml|
          @sisu_base=[]
          if xml =~/\.sx[sdn]\.xml$/
            begin
              @doc_str=IO.readlines(xml,'').join("\n")
              @output=File.new("#{xml}.sst",'w')
              @doc=REXML::Document.new(@doc_str)
              @output_file_name="#{Dir.pwd}/#{xml}.sst"
              @el=[]
            rescue REXML::ParseException
            end
          end
          if xml =~/\.sxs\.xml$/
            unless @opt.act[:quiet][:set]==:on
              tell(xml,'sax')
            end
            sax
          elsif xml =~/\.sxd\.xml$/
            unless @opt.act[:quiet][:set]==:on
              tell(xml,'dom')
            end
            dom
          elsif xml =~/\.sxn\.xml$/
            unless @opt.act[:quiet][:set]==:on
              tell(xml,'node')
            end
            node
          else puts "filename not recognised: << #{xml} >>"
          end
          @output << @sisu_base
        end
      else puts '.xml file for conversion to sisu expected'
      end
      puts @opt.files.inspect
    end
  end
end
__END__
