"""Add n_participants attributes to Room

Should have been part of another commit, but I messed up some rebase

Revision ID: 09f27f098baa
Revises: 29f5280c61aa
Create Date: 2024-07-11 10:54:21.155871

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "09f27f098baa"
down_revision: Union[str, None] = "29f5280c61aa"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.add_column(sa.Column("n_participants", sa.Integer(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.drop_column("n_participants")

    # ### end Alembic commands ###
