/*
 * VRT RULES
 *
 * Copyright (C) 2014-2019 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule2570eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule2570flow0 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule2570option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule2570flow0 }
};
// content:"HTTP/", nocase;
static ContentInfo rule2570content1 =
{
    (u_int8_t *)("HTTP/"), /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2570option1 =
{
    OPTION_TYPE_CONTENT,
    { &rule2570content1 }
};
// isdataat:offset 6, relative;
static CursorInfo rule2570isdataat2 =
{
    6, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, // offset_refId
    NULL  // offset_location
};

static RuleOption rule2570option2 =
{
    OPTION_TYPE_CURSOR,
    { &rule2570isdataat2 }
};
// content:"|0A|", depth 5, relative;
static ContentInfo rule2570content3 =
{
    (u_int8_t *)("|0A|"), /* pattern (now in snort content format) */
    5, /* depth */
    0, /* offset */
    NOT_FLAG|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2570option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule2570content3 }
};

/* references for sid 2570 */
/* reference: bugtraq "9809"; */
static RuleReference rule2570ref1 =
{
    "bugtraq", /* type */
    "9809" /* value */
};

/* reference: nessus "11593"; */
static RuleReference rule2570ref2 =
{
    "nessus", /* type */
    "11593" /* value */
};

static RuleReference *rule2570refs[] =
{
    &rule2570ref1,
    &rule2570ref2,
    NULL
};
RuleOption *rule2570options[] =
{
    &rule2570option0,
    &rule2570option1,
    &rule2570option2,
    &rule2570option3,
    NULL
};

Rule rule2570 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$HTTP_SERVERS", /* DSTIP     */
       "$HTTP_PORTS", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       2570, /* sigid */
       7, /* revision */

       "non-standard-protocol", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "!! Dynamic !!  WEB-MISC Invalid HTTP Version String",     /* message */
       rule2570refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule2570options, /* ptr to rule options */
   NULL, //&rule2570eval, /* use the built in detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule2570eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // flow:established, to_server;
    if (checkFlow(p, rule2570options[0]->option_u.flowFlags) > 0 ) {
        // content:"HTTP/", nocase;
        if (contentMatch(p, rule2570options[1]->option_u.content, &cursor_normal) > 0) {
            // isdataat:offset 6, relative;
            if (checkCursor(p, rule2570options[2]->option_u.cursor, cursor_normal) > 0) {
                // content:"|0A|", depth 5, relative;
                if (!(contentMatch(p, rule2570options[3]->option_u.content, &cursor_normal) > 0)) {
                    return RULE_MATCH;
                }
            }
        }
    }
    return RULE_NOMATCH;
}

