/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "subcommander/wcview/ItemModel.h"
#include "subcommander/BadItemException.h"
#include "subcommander-test/WcViewItemTest.h"
#include "sublib/OStreamQt.h"
#include "util-test/Link.h"
EXPORT_TESTCASE (AddingABadItemToAModel);

// gmock
#include <gmock/gmock.h>


namespace wcview
{


class AddingABadItemToAModel : public ::testing::Test
{
protected:
  AddingABadItemToAModel () 
    : _model(sc::String("invisible/root"), &_data)
  {
    _badRootItem = createItem("invisible/badroot",
      WcViewItemTypeDir,WcViewItemStateNormal);
  }

protected:
  WcViewItemDataTest _data;
  ItemModel          _model;
  WcViewItemPtr      _badRootItem;
};


TEST_F (AddingABadItemToAModel,shouldThrowBadItemException)
{
  EXPECT_THROW (_model.insert (_badRootItem), BadItemException );
}


} // namespace
