/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCSTATUSLVI_H
#define _SC_WCSTATUSLVI_H

// sc
#include "svn/WcStatus.h"

// qt
#include <Qt3Support/Q3ListView>


class WcStatusLvi : public Q3ListViewItem
{
  typedef Q3ListViewItem super;

public:
  WcStatusLvi( Q3ListView* parent, const svn::WcStatusPtr status );
  WcStatusLvi( Q3ListViewItem* parent, const svn::WcStatusPtr status );
  virtual ~WcStatusLvi();

  void startRename( int col );
  void okRename( int col );
  void cancelRename( int col );
  //void paintFocus( QPainter* p, const QColorGroup& cg, const QRect& r );
  void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment );
  //void paintBranches( QPainter* p, const QColorGroup& cg, int w, int y, int h, GUIStyle s );

  bool acceptDrop( const QMimeSource* mime ) const;

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;

  int compare( Q3ListViewItem * i, int col, bool ascending ) const;

  void setParentPath( const QString& parentPath );
  void setDeepStatus( const QString& );
  const QString& getParentPath() const;
  svn::WcStatusPtr getStatus() const;

private:
  void init();
  bool isInVisibleArea() const;

  QString          _parentPath;
  svn::WcStatusPtr _status;
  
  bool             _rename;      ///< we are in a rename?
};

#endif // _SC_WCSTATUSLVI_H
