/* ====================================================================
 * Copyright (c) 2003-2006  Martin Hauner
 *               2008-2009  http://subcommander.tigris.org                                     
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGINGEVENT_H
#define _SC_LOGGINGEVENT_H

// sc
#include "CustomEvents.h"
#include "../LogData.h"

// qt
#include <QtCore/QEvent>

/**
 * Event class for logging.
 */
class LoggingEvent : public QEvent
{
public:
  LoggingEvent( const LogData* data )
    : QEvent((QEvent::Type)ScLoggingEvent), _data(data)
  {
  }

  LogDataPtr getData() const
  {
    return _data;
  }

private:
  LogDataPtr _data;
};

#endif //  _SC_LOGGINGEVENT_H
