/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TargetId.h"
#include "TargetRepository.h"

// qt
#include <QtCore/QObject>

// sys
#include <cassert>


TargetId::TargetId( QObject* o )
{
  _tid = TargetRepository::create();
  TargetRepository::add( _tid, o );
}

TargetId::~TargetId()
{
  TargetRepository::del(_tid);
}

ID TargetId::getTid() const
{
  return _tid;
}

ID TargetId::getTid( QObject* o )
{
  TargetId* p = dynamic_cast<TargetId*>(o);

  if( p )
  {
    return p->getTid();
  }

  assert(false);
  return 0;
}
