/* ====================================================================
 * Copyright (c) 2006, 2008  Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TARGETREPOSITORY_H
#define _SC_TARGETREPOSITORY_H

// sc
#include "util/Id.h"

// qt
class QObject;

/**
 * Manages a target id -> object map.
 */
class TargetRepository
{
public:
  /**
   * initialize the TargetRepository.
   */
  static void setup();
  
  /**
   * cleanup the TargetRepository.
   */
  static void teardown();

  /**
   * create a new target id used in the add and del method calls.
   */
  static ID create();

  /**
   * add a new target to the object map.
   */
  static void add( ID tid, QObject* o );

  /**
   * returns the object to a given target id or NULL if the object is
   * not registered.
   */
  static QObject* get( ID tid );

  /**
   * remove a target from the object map.
   */
  static void del( ID tid );
  
  /**
   * set error target id. An object for the id must be set with add().
   */
  static void setError( ID errortid ); 
  
  /**
   * returns the object to the error target id configured by setup().
   */
  static QObject* getError();
};


#endif // _SC_TARGETREPOSITORY_H
