/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Error.h"
#include "ErrorImpl.h"

// svn
#include <svn_error.h>


namespace svn
{

svn_error_t* unwrapError( sc::Error* err )
{
  ErrorImpl*   ei      = dynamic_cast<ErrorImpl*>(err);
  svn_error_t *svn_err = SVN_NO_ERROR;

  if( ei )
  {
	  svn_err = ei->getError();
    svn_err = svn_error_dup(svn_err);
	  delete ei;
  }

  return svn_err;
}

sc::Error* wrapError( svn_error_t* err )
{
  if( err == SVN_NO_ERROR )
  {
    return sc::Success;
  }

  return new ErrorImpl(err);
}

} // namespace;
