/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEDIALOG_H
#define _SC_MERGEDIALOG_H

// sc
class MergeViewModel;
class RevisionWidget;
class MergeParam;
class ExternProvider;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QWidget>
class QComboBox;
class QCheckBox;
class QPushButton;
class QLabel;


class MergeDialog : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  MergeDialog( MergeViewModel* model, ExternProvider* p, QWidget *parent = 0 );
  virtual ~MergeDialog();

  void enablePathOrUrl1( bool enable );
  void enablePathOrUrl2( bool enable );
  void enableTypeChange( bool enable );

public slots:
  void accept();
  void dryrun();
  void reject();

  void changedMergeType( bool );
  void selectRep1Url();
  void selectRep2Url();
  void selectWcPath();
  void checkOk( const QString& text );

private slots:
  void rep1Changed( const QString& );
  void rep2Changed( const QString& );
  void wcChanged( const QString& rep );

private:
  MergeViewModel* _model;
  ExternProvider* _p;

  QLabel*         _rep1L;
  QComboBox*      _rep1;
  QPushButton*    _rep1B;

  QCheckBox*      _type;
  QComboBox*      _rep2;
  QLabel*         _rep2L;
  QPushButton*    _rep2B;

  QComboBox*      _wc;

  RevisionWidget* _rwPeg;
  RevisionWidget* _rw1;
  RevisionWidget* _rw2;

  QCheckBox*      _recurse;
  QCheckBox*      _ancestry;
  QCheckBox*      _force;

  QPushButton*    _ok;
  QPushButton*    _dry;
};

#endif // _SC_MERGEDIALOG_H
